/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.constants.GsonType;
import com.ctrip.framework.apollo.common.dto.ItemDTO;
import com.ctrip.framework.apollo.common.dto.NamespaceDTO;
import com.ctrip.framework.apollo.common.dto.ReleaseDTO;
import com.ctrip.framework.apollo.common.entity.AppNamespace;
import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.component.PortalSettings;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.entity.bo.ItemBO;
import com.ctrip.framework.apollo.portal.entity.bo.NamespaceBO;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.AppNamespaceService;
import com.ctrip.framework.apollo.portal.service.InstanceService;
import com.ctrip.framework.apollo.portal.service.ItemService;
import com.ctrip.framework.apollo.portal.service.NamespaceBranchService;
import com.ctrip.framework.apollo.portal.service.ReleaseService;
import com.ctrip.framework.apollo.portal.service.RolePermissionService;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.portal.util.RoleUtils;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NamespaceService {
    private Logger logger = LoggerFactory.getLogger(NamespaceService.class);
    private Gson gson = new Gson();
    private final PortalConfig portalConfig;
    private final PortalSettings portalSettings;
    private final UserInfoHolder userInfoHolder;
    private final AdminServiceAPI.NamespaceAPI namespaceAPI;
    private final ItemService itemService;
    private final ReleaseService releaseService;
    private final AppNamespaceService appNamespaceService;
    private final InstanceService instanceService;
    private final NamespaceBranchService branchService;
    private final RolePermissionService rolePermissionService;

    public NamespaceService(PortalConfig portalConfig, PortalSettings portalSettings, UserInfoHolder userInfoHolder, AdminServiceAPI.NamespaceAPI namespaceAPI, ItemService itemService, ReleaseService releaseService, AppNamespaceService appNamespaceService, InstanceService instanceService, @Lazy NamespaceBranchService branchService, RolePermissionService rolePermissionService) {
        this.portalConfig = portalConfig;
        this.portalSettings = portalSettings;
        this.userInfoHolder = userInfoHolder;
        this.namespaceAPI = namespaceAPI;
        this.itemService = itemService;
        this.releaseService = releaseService;
        this.appNamespaceService = appNamespaceService;
        this.instanceService = instanceService;
        this.branchService = branchService;
        this.rolePermissionService = rolePermissionService;
    }

    public NamespaceDTO createNamespace(Env env, NamespaceDTO namespace) {
        if (StringUtils.isEmpty((String)namespace.getDataChangeCreatedBy())) {
            namespace.setDataChangeCreatedBy(this.userInfoHolder.getUser().getUserId());
        }
        namespace.setDataChangeLastModifiedBy(this.userInfoHolder.getUser().getUserId());
        NamespaceDTO createdNamespace = this.namespaceAPI.createNamespace(env, namespace);
        Tracer.logEvent((String)"Namespace.Create", (String)String.format("%s+%s+%s+%s", namespace.getAppId(), env, namespace.getClusterName(), namespace.getNamespaceName()));
        return createdNamespace;
    }

    @Transactional
    public void deleteNamespace(String appId, Env env, String clusterName, String namespaceName) {
        AppNamespace appNamespace = this.appNamespaceService.findByAppIdAndName(appId, namespaceName);
        if (this.namespaceHasInstances(appId, env, clusterName, namespaceName)) {
            throw new BadRequestException("Can not delete namespace because namespace has active instances");
        }
        NamespaceDTO childNamespace = this.branchService.findBranchBaseInfo(appId, env, clusterName, namespaceName);
        if (childNamespace != null && this.namespaceHasInstances(appId, env, childNamespace.getClusterName(), namespaceName)) {
            throw new BadRequestException("Can not delete namespace because namespace's branch has active instances");
        }
        if (appNamespace != null && appNamespace.isPublic() && this.publicAppNamespaceHasAssociatedNamespace(namespaceName, env)) {
            throw new BadRequestException("Can not delete public namespace which has associated namespaces");
        }
        String operator = this.userInfoHolder.getUser().getUserId();
        this.namespaceAPI.deleteNamespace(env, appId, clusterName, namespaceName, operator);
    }

    public NamespaceDTO loadNamespaceBaseInfo(String appId, Env env, String clusterName, String namespaceName) {
        NamespaceDTO namespace = this.namespaceAPI.loadNamespace(appId, env, clusterName, namespaceName);
        if (namespace == null) {
            throw new BadRequestException(String.format("Namespace: %s not exist.", namespaceName));
        }
        return namespace;
    }

    public List<NamespaceBO> findNamespaceBOs(String appId, Env env, String clusterName) {
        List<NamespaceDTO> namespaces = this.namespaceAPI.findNamespaceByCluster(appId, env, clusterName);
        if (namespaces == null || namespaces.size() == 0) {
            throw new BadRequestException("namespaces not exist");
        }
        LinkedList<NamespaceBO> namespaceBOs = new LinkedList<NamespaceBO>();
        for (NamespaceDTO namespace : namespaces) {
            try {
                NamespaceBO namespaceBO = this.transformNamespace2BO(env, namespace);
                namespaceBOs.add(namespaceBO);
            }
            catch (Exception e) {
                this.logger.error("parse namespace error. app id:{}, env:{}, clusterName:{}, namespace:{}", new Object[]{appId, env, clusterName, namespace.getNamespaceName(), e});
                throw e;
            }
        }
        return namespaceBOs;
    }

    public List<NamespaceDTO> findNamespaces(String appId, Env env, String clusterName) {
        return this.namespaceAPI.findNamespaceByCluster(appId, env, clusterName);
    }

    public List<NamespaceDTO> getPublicAppNamespaceAllNamespaces(Env env, String publicNamespaceName, int page, int size) {
        return this.namespaceAPI.getPublicAppNamespaceAllNamespaces(env, publicNamespaceName, page, size);
    }

    public NamespaceBO loadNamespaceBO(String appId, Env env, String clusterName, String namespaceName) {
        NamespaceDTO namespace = this.namespaceAPI.loadNamespace(appId, env, clusterName, namespaceName);
        if (namespace == null) {
            throw new BadRequestException("namespaces not exist");
        }
        return this.transformNamespace2BO(env, namespace);
    }

    public boolean namespaceHasInstances(String appId, Env env, String clusterName, String namespaceName) {
        return this.instanceService.getInstanceCountByNamepsace(appId, env, clusterName, namespaceName) > 0;
    }

    public boolean publicAppNamespaceHasAssociatedNamespace(String publicNamespaceName, Env env) {
        return this.namespaceAPI.countPublicAppNamespaceAssociatedNamespaces(env, publicNamespaceName) > 0;
    }

    public NamespaceBO findPublicNamespaceForAssociatedNamespace(Env env, String appId, String clusterName, String namespaceName) {
        NamespaceDTO namespace = this.namespaceAPI.findPublicNamespaceForAssociatedNamespace(env, appId, clusterName, namespaceName);
        return this.transformNamespace2BO(env, namespace);
    }

    public Map<String, Map<String, Boolean>> getNamespacesPublishInfo(String appId) {
        HashMap result = Maps.newHashMap();
        Set<Env> envs = this.portalConfig.publishTipsSupportedEnvs();
        for (Env env : envs) {
            if (!this.portalSettings.isEnvActive(env)) continue;
            result.put(env.toString(), this.namespaceAPI.getNamespacePublishInfo(env, appId));
        }
        return result;
    }

    private NamespaceBO transformNamespace2BO(Env env, NamespaceDTO namespace) {
        NamespaceBO namespaceBO = new NamespaceBO();
        namespaceBO.setBaseInfo(namespace);
        String appId = namespace.getAppId();
        String clusterName = namespace.getClusterName();
        String namespaceName = namespace.getNamespaceName();
        this.fillAppNamespaceProperties(namespaceBO);
        LinkedList<ItemBO> itemBOs = new LinkedList<ItemBO>();
        namespaceBO.setItems(itemBOs);
        HashMap<String, String> releaseItems = new HashMap();
        HashMap<String, ItemDTO> deletedItemDTOs = new HashMap<String, ItemDTO>();
        ReleaseDTO latestRelease = this.releaseService.loadLatestRelease(appId, env, clusterName, namespaceName);
        if (latestRelease != null) {
            releaseItems = (Map)this.gson.fromJson(latestRelease.getConfigurations(), GsonType.CONFIG);
        }
        List<ItemDTO> items = this.itemService.findItems(appId, env, clusterName, namespaceName);
        int modifiedItemCnt = 0;
        for (ItemDTO itemDTO : items) {
            ItemBO itemBO = this.transformItem2BO(itemDTO, releaseItems);
            if (itemBO.isModified()) {
                ++modifiedItemCnt;
            }
            itemBOs.add(itemBO);
        }
        this.itemService.findDeletedItems(appId, env, clusterName, namespaceName).forEach(item -> deletedItemDTOs.put(item.getKey(), (ItemDTO)item));
        List<ItemBO> deletedItems = this.parseDeletedItems(items, releaseItems, deletedItemDTOs);
        itemBOs.addAll(deletedItems);
        namespaceBO.setItemModifiedCnt(modifiedItemCnt += deletedItems.size());
        return namespaceBO;
    }

    private void fillAppNamespaceProperties(NamespaceBO namespace) {
        boolean isPublic;
        String format;
        NamespaceDTO namespaceDTO = namespace.getBaseInfo();
        String appId = namespaceDTO.getAppId();
        String clusterName = namespaceDTO.getClusterName();
        String namespaceName = namespaceDTO.getNamespaceName();
        AppNamespace appNamespace = this.appNamespaceService.findByAppIdAndName(appId, namespaceName);
        if (appNamespace == null) {
            appNamespace = this.appNamespaceService.findPublicAppNamespace(namespaceName);
        }
        if (appNamespace == null) {
            this.logger.warn("Dirty data, cannot find appNamespace by namespaceName [{}], appId = {}, cluster = {}, set it format to {}, make public", new Object[]{namespaceName, appId, clusterName, ConfigFileFormat.Properties.getValue()});
            format = ConfigFileFormat.Properties.getValue();
            isPublic = true;
        } else {
            format = appNamespace.getFormat();
            isPublic = appNamespace.isPublic();
            namespace.setParentAppId(appNamespace.getAppId());
            namespace.setComment(appNamespace.getComment());
        }
        namespace.setFormat(format);
        namespace.setPublic(isPublic);
    }

    private List<ItemBO> parseDeletedItems(List<ItemDTO> newItems, Map<String, String> releaseItems, Map<String, ItemDTO> deletedItemDTOs) {
        Map newItemMap = BeanUtils.mapByKey((String)"key", newItems);
        LinkedList<ItemBO> deletedItems = new LinkedList<ItemBO>();
        for (Map.Entry<String, String> entry : releaseItems.entrySet()) {
            String key = entry.getKey();
            if (newItemMap.get(key) != null) continue;
            ItemBO deletedItem = new ItemBO();
            deletedItem.setDeleted(true);
            ItemDTO deletedItemDto = deletedItemDTOs.computeIfAbsent(key, k -> new ItemDTO());
            deletedItemDto.setKey(key);
            String oldValue = entry.getValue();
            deletedItem.setItem(deletedItemDto);
            deletedItemDto.setValue(oldValue);
            deletedItem.setModified(true);
            deletedItem.setOldValue(oldValue);
            deletedItem.setNewValue("");
            deletedItems.add(deletedItem);
        }
        return deletedItems;
    }

    private ItemBO transformItem2BO(ItemDTO itemDTO, Map<String, String> releaseItems) {
        String key = itemDTO.getKey();
        ItemBO itemBO = new ItemBO();
        itemBO.setItem(itemDTO);
        String newValue = itemDTO.getValue();
        String oldValue = releaseItems.get(key);
        if (!(StringUtils.isEmpty((String)key) || oldValue != null && newValue.equals(oldValue))) {
            itemBO.setModified(true);
            itemBO.setOldValue(oldValue == null ? "" : oldValue);
            itemBO.setNewValue(newValue);
        }
        return itemBO;
    }

    public void assignNamespaceRoleToOperator(String appId, String namespaceName, String operator) {
        this.rolePermissionService.assignRoleToUsers(RoleUtils.buildNamespaceRoleName(appId, namespaceName, "ModifyNamespace"), Sets.newHashSet((Object[])new String[]{operator}), operator);
        this.rolePermissionService.assignRoleToUsers(RoleUtils.buildNamespaceRoleName(appId, namespaceName, "ReleaseNamespace"), Sets.newHashSet((Object[])new String[]{operator}), operator);
    }
}

