/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.dto.GrayReleaseRuleDTO;
import com.ctrip.framework.apollo.common.dto.ItemChangeSets;
import com.ctrip.framework.apollo.common.dto.ItemDTO;
import com.ctrip.framework.apollo.common.dto.NamespaceDTO;
import com.ctrip.framework.apollo.common.dto.ReleaseDTO;
import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.component.ItemsComparator;
import com.ctrip.framework.apollo.portal.entity.bo.NamespaceBO;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.ItemService;
import com.ctrip.framework.apollo.portal.service.NamespaceService;
import com.ctrip.framework.apollo.portal.service.ReleaseService;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.tracer.Tracer;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NamespaceBranchService {
    private final ItemsComparator itemsComparator;
    private final UserInfoHolder userInfoHolder;
    private final NamespaceService namespaceService;
    private final ItemService itemService;
    private final AdminServiceAPI.NamespaceBranchAPI namespaceBranchAPI;
    private final ReleaseService releaseService;

    public NamespaceBranchService(ItemsComparator itemsComparator, UserInfoHolder userInfoHolder, NamespaceService namespaceService, ItemService itemService, AdminServiceAPI.NamespaceBranchAPI namespaceBranchAPI, ReleaseService releaseService) {
        this.itemsComparator = itemsComparator;
        this.userInfoHolder = userInfoHolder;
        this.namespaceService = namespaceService;
        this.itemService = itemService;
        this.namespaceBranchAPI = namespaceBranchAPI;
        this.releaseService = releaseService;
    }

    @Transactional
    public NamespaceDTO createBranch(String appId, Env env, String parentClusterName, String namespaceName) {
        String operator = this.userInfoHolder.getUser().getUserId();
        return this.createBranch(appId, env, parentClusterName, namespaceName, operator);
    }

    @Transactional
    public NamespaceDTO createBranch(String appId, Env env, String parentClusterName, String namespaceName, String operator) {
        NamespaceDTO createdBranch = this.namespaceBranchAPI.createBranch(appId, env, parentClusterName, namespaceName, operator);
        Tracer.logEvent((String)"GrayRelease.Create", (String)String.format("%s+%s+%s+%s", appId, env, parentClusterName, namespaceName));
        return createdBranch;
    }

    public GrayReleaseRuleDTO findBranchGrayRules(String appId, Env env, String clusterName, String namespaceName, String branchName) {
        return this.namespaceBranchAPI.findBranchGrayRules(appId, env, clusterName, namespaceName, branchName);
    }

    public void updateBranchGrayRules(String appId, Env env, String clusterName, String namespaceName, String branchName, GrayReleaseRuleDTO rules) {
        String operator = this.userInfoHolder.getUser().getUserId();
        this.updateBranchGrayRules(appId, env, clusterName, namespaceName, branchName, rules, operator);
    }

    public void updateBranchGrayRules(String appId, Env env, String clusterName, String namespaceName, String branchName, GrayReleaseRuleDTO rules, String operator) {
        rules.setDataChangeCreatedBy(operator);
        rules.setDataChangeLastModifiedBy(operator);
        this.namespaceBranchAPI.updateBranchGrayRules(appId, env, clusterName, namespaceName, branchName, rules);
        Tracer.logEvent((String)"GrayReleaseRule.Update", (String)String.format("%s+%s+%s+%s", appId, env, clusterName, namespaceName));
    }

    public void deleteBranch(String appId, Env env, String clusterName, String namespaceName, String branchName) {
        String operator = this.userInfoHolder.getUser().getUserId();
        this.deleteBranch(appId, env, clusterName, namespaceName, branchName, operator);
    }

    public void deleteBranch(String appId, Env env, String clusterName, String namespaceName, String branchName, String operator) {
        this.namespaceBranchAPI.deleteBranch(appId, env, clusterName, namespaceName, branchName, operator);
        Tracer.logEvent((String)"GrayRelease.Delete", (String)String.format("%s+%s+%s+%s", appId, env, clusterName, namespaceName));
    }

    public ReleaseDTO merge(String appId, Env env, String clusterName, String namespaceName, String branchName, String title, String comment, boolean isEmergencyPublish, boolean deleteBranch) {
        String operator = this.userInfoHolder.getUser().getUserId();
        return this.merge(appId, env, clusterName, namespaceName, branchName, title, comment, isEmergencyPublish, deleteBranch, operator);
    }

    public ReleaseDTO merge(String appId, Env env, String clusterName, String namespaceName, String branchName, String title, String comment, boolean isEmergencyPublish, boolean deleteBranch, String operator) {
        ItemChangeSets changeSets = this.calculateBranchChangeSet(appId, env, clusterName, namespaceName, branchName, operator);
        ReleaseDTO mergedResult = this.releaseService.updateAndPublish(appId, env, clusterName, namespaceName, title, comment, branchName, isEmergencyPublish, deleteBranch, changeSets);
        Tracer.logEvent((String)"GrayRelease.Merge", (String)String.format("%s+%s+%s+%s", appId, env, clusterName, namespaceName));
        return mergedResult;
    }

    private ItemChangeSets calculateBranchChangeSet(String appId, Env env, String clusterName, String namespaceName, String branchName, String operator) {
        NamespaceBO parentNamespace = this.namespaceService.loadNamespaceBO(appId, env, clusterName, namespaceName);
        if (parentNamespace == null) {
            throw new BadRequestException("base namespace not existed");
        }
        if (parentNamespace.getItemModifiedCnt() > 0) {
            throw new BadRequestException("Merge operation failed. Because master has modified items");
        }
        List<ItemDTO> masterItems = this.itemService.findItems(appId, env, clusterName, namespaceName);
        List<ItemDTO> branchItems = this.itemService.findItems(appId, env, branchName, namespaceName);
        ItemChangeSets changeSets = this.itemsComparator.compareIgnoreBlankAndCommentItem(parentNamespace.getBaseInfo().getId(), masterItems, branchItems);
        changeSets.setDeleteItems(Collections.emptyList());
        changeSets.setDataChangeLastModifiedBy(operator);
        return changeSets;
    }

    public NamespaceDTO findBranchBaseInfo(String appId, Env env, String clusterName, String namespaceName) {
        return this.namespaceBranchAPI.findBranch(appId, env, clusterName, namespaceName);
    }

    public NamespaceBO findBranch(String appId, Env env, String clusterName, String namespaceName) {
        NamespaceDTO namespaceDTO = this.findBranchBaseInfo(appId, env, clusterName, namespaceName);
        if (namespaceDTO == null) {
            return null;
        }
        return this.namespaceService.loadNamespaceBO(appId, env, namespaceDTO.getClusterName(), namespaceName);
    }
}

