/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.constants.GsonType;
import com.ctrip.framework.apollo.common.dto.ItemChangeSets;
import com.ctrip.framework.apollo.common.dto.ItemDTO;
import com.ctrip.framework.apollo.common.dto.NamespaceDTO;
import com.ctrip.framework.apollo.common.dto.ReleaseDTO;
import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.component.txtresolver.ConfigTextResolver;
import com.ctrip.framework.apollo.portal.entity.model.NamespaceTextModel;
import com.ctrip.framework.apollo.portal.entity.vo.ItemDiffs;
import com.ctrip.framework.apollo.portal.entity.vo.NamespaceIdentifier;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.HttpClientErrorException;

@Service
public class ItemService {
    private Gson gson = new Gson();
    private final UserInfoHolder userInfoHolder;
    private final AdminServiceAPI.NamespaceAPI namespaceAPI;
    private final AdminServiceAPI.ItemAPI itemAPI;
    private final AdminServiceAPI.ReleaseAPI releaseAPI;
    private final ConfigTextResolver fileTextResolver;
    private final ConfigTextResolver propertyResolver;

    public ItemService(UserInfoHolder userInfoHolder, AdminServiceAPI.NamespaceAPI namespaceAPI, AdminServiceAPI.ItemAPI itemAPI, AdminServiceAPI.ReleaseAPI releaseAPI, @Qualifier(value="fileTextResolver") ConfigTextResolver fileTextResolver, @Qualifier(value="propertyResolver") ConfigTextResolver propertyResolver) {
        this.userInfoHolder = userInfoHolder;
        this.namespaceAPI = namespaceAPI;
        this.itemAPI = itemAPI;
        this.releaseAPI = releaseAPI;
        this.fileTextResolver = fileTextResolver;
        this.propertyResolver = propertyResolver;
    }

    public void updateConfigItemByText(NamespaceTextModel model) {
        String namespaceName;
        String clusterName;
        Env env;
        String appId = model.getAppId();
        NamespaceDTO namespace = this.namespaceAPI.loadNamespace(appId, env = model.getEnv(), clusterName = model.getClusterName(), namespaceName = model.getNamespaceName());
        if (namespace == null) {
            throw new BadRequestException("namespace:" + namespaceName + " not exist in env:" + env + ", cluster:" + clusterName);
        }
        long namespaceId = namespace.getId();
        String configText = model.getConfigText();
        ConfigTextResolver resolver = model.getFormat() == ConfigFileFormat.Properties ? this.propertyResolver : this.fileTextResolver;
        ItemChangeSets changeSets = resolver.resolve(namespaceId, configText, this.itemAPI.findItems(appId, env, clusterName, namespaceName));
        if (changeSets.isEmpty()) {
            return;
        }
        changeSets.setDataChangeLastModifiedBy(this.userInfoHolder.getUser().getUserId());
        this.updateItems(appId, env, clusterName, namespaceName, changeSets);
        Tracer.logEvent((String)"Namespace.Modify.Text", (String)String.format("%s+%s+%s+%s", appId, env, clusterName, namespaceName));
        Tracer.logEvent((String)"Namespace.Modify", (String)String.format("%s+%s+%s+%s", appId, env, clusterName, namespaceName));
    }

    public void updateItems(String appId, Env env, String clusterName, String namespaceName, ItemChangeSets changeSets) {
        this.itemAPI.updateItemsByChangeSet(appId, env, clusterName, namespaceName, changeSets);
    }

    public ItemDTO createItem(String appId, Env env, String clusterName, String namespaceName, ItemDTO item) {
        NamespaceDTO namespace = this.namespaceAPI.loadNamespace(appId, env, clusterName, namespaceName);
        if (namespace == null) {
            throw new BadRequestException("namespace:" + namespaceName + " not exist in env:" + env + ", cluster:" + clusterName);
        }
        item.setNamespaceId(namespace.getId());
        ItemDTO itemDTO = this.itemAPI.createItem(appId, env, clusterName, namespaceName, item);
        Tracer.logEvent((String)"Namespace.Modify", (String)String.format("%s+%s+%s+%s", appId, env, clusterName, namespaceName));
        return itemDTO;
    }

    public void updateItem(String appId, Env env, String clusterName, String namespaceName, ItemDTO item) {
        this.itemAPI.updateItem(appId, env, clusterName, namespaceName, item.getId(), item);
    }

    public void deleteItem(Env env, long itemId, String userId) {
        this.itemAPI.deleteItem(env, itemId, userId);
    }

    public List<ItemDTO> findItems(String appId, Env env, String clusterName, String namespaceName) {
        return this.itemAPI.findItems(appId, env, clusterName, namespaceName);
    }

    public List<ItemDTO> findDeletedItems(String appId, Env env, String clusterName, String namespaceName) {
        return this.itemAPI.findDeletedItems(appId, env, clusterName, namespaceName);
    }

    public ItemDTO loadItem(Env env, String appId, String clusterName, String namespaceName, String key) {
        return this.itemAPI.loadItem(env, appId, clusterName, namespaceName, key);
    }

    public ItemDTO loadItemById(Env env, long itemId) {
        ItemDTO item = this.itemAPI.loadItemById(env, itemId);
        if (item == null) {
            throw new BadRequestException("item not found for itemId " + itemId);
        }
        return item;
    }

    public void syncItems(List<NamespaceIdentifier> comparedNamespaces, List<ItemDTO> sourceItems) {
        List<ItemDiffs> itemDiffs = this.compare(comparedNamespaces, sourceItems);
        for (ItemDiffs itemDiff : itemDiffs) {
            NamespaceIdentifier namespaceIdentifier = itemDiff.getNamespace();
            ItemChangeSets changeSets = itemDiff.getDiffs();
            changeSets.setDataChangeLastModifiedBy(this.userInfoHolder.getUser().getUserId());
            String appId = namespaceIdentifier.getAppId();
            Env env = namespaceIdentifier.getEnv();
            String clusterName = namespaceIdentifier.getClusterName();
            String namespaceName = namespaceIdentifier.getNamespaceName();
            this.itemAPI.updateItemsByChangeSet(appId, env, clusterName, namespaceName, changeSets);
            Tracer.logEvent((String)"Namespace.Sync", (String)String.format("%s+%s+%s+%s", appId, env, clusterName, namespaceName));
        }
    }

    public void revokeItem(String appId, Env env, String clusterName, String namespaceName) {
        NamespaceDTO namespace = this.namespaceAPI.loadNamespace(appId, env, clusterName, namespaceName);
        if (namespace == null) {
            throw new BadRequestException("namespace:" + namespaceName + " not exist in env:" + env + ", cluster:" + clusterName);
        }
        long namespaceId = namespace.getId();
        Map<String, String> releaseItemDTOs = new HashMap();
        ReleaseDTO latestRelease = this.releaseAPI.loadLatestRelease(appId, env, clusterName, namespaceName);
        if (latestRelease != null) {
            releaseItemDTOs = (Map)this.gson.fromJson(latestRelease.getConfigurations(), GsonType.CONFIG);
        }
        List<ItemDTO> baseItems = this.itemAPI.findItems(appId, env, clusterName, namespaceName);
        Map oldKeyMapItem = BeanUtils.mapByKey((String)"key", baseItems);
        HashMap deletedItemDTOs = new HashMap();
        this.findDeletedItems(appId, env, clusterName, namespaceName).forEach(item -> deletedItemDTOs.put(item.getKey(), item));
        ItemChangeSets changeSets = new ItemChangeSets();
        AtomicInteger lineNum = new AtomicInteger(1);
        releaseItemDTOs.forEach((key, value) -> {
            ItemDTO oldItem = (ItemDTO)oldKeyMapItem.get(key);
            if (oldItem == null) {
                ItemDTO deletedItemDto = deletedItemDTOs.computeIfAbsent(key, k -> new ItemDTO());
                changeSets.addCreateItem(this.buildNormalItem(0L, namespaceId, (String)key, (String)value, deletedItemDto.getComment(), lineNum.get()));
            } else if (!oldItem.getValue().equals(value) || lineNum.get() != oldItem.getLineNum()) {
                changeSets.addUpdateItem(this.buildNormalItem(oldItem.getId(), namespaceId, (String)key, (String)value, oldItem.getComment(), lineNum.get()));
            }
            oldKeyMapItem.remove(key);
            lineNum.set(lineNum.get() + 1);
        });
        oldKeyMapItem.forEach((key, value) -> changeSets.addDeleteItem((ItemDTO)oldKeyMapItem.get(key)));
        changeSets.setDataChangeLastModifiedBy(this.userInfoHolder.getUser().getUserId());
        this.updateItems(appId, env, clusterName, namespaceName, changeSets);
        Tracer.logEvent((String)"Namespace.Modify.Text", (String)String.format("%s+%s+%s+%s", appId, env, clusterName, namespaceName));
        Tracer.logEvent((String)"Namespace.Modify", (String)String.format("%s+%s+%s+%s", appId, env, clusterName, namespaceName));
    }

    public List<ItemDiffs> compare(List<NamespaceIdentifier> comparedNamespaces, List<ItemDTO> sourceItems) {
        LinkedList<ItemDiffs> result = new LinkedList<ItemDiffs>();
        for (NamespaceIdentifier namespace : comparedNamespaces) {
            ItemDiffs itemDiffs = new ItemDiffs(namespace);
            try {
                itemDiffs.setDiffs(this.parseChangeSets(namespace, sourceItems));
            }
            catch (BadRequestException e) {
                itemDiffs.setDiffs(new ItemChangeSets());
                itemDiffs.setExtInfo("\u8be5\u96c6\u7fa4\u4e0b\u6ca1\u6709\u540d\u4e3a " + namespace.getNamespaceName() + " \u7684namespace");
            }
            result.add(itemDiffs);
        }
        return result;
    }

    private long getNamespaceId(NamespaceIdentifier namespaceIdentifier) {
        String appId = namespaceIdentifier.getAppId();
        String clusterName = namespaceIdentifier.getClusterName();
        String namespaceName = namespaceIdentifier.getNamespaceName();
        Env env = namespaceIdentifier.getEnv();
        NamespaceDTO namespaceDTO = null;
        try {
            namespaceDTO = this.namespaceAPI.loadNamespace(appId, env, clusterName, namespaceName);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                throw new BadRequestException(String.format("namespace not exist. appId:%s, env:%s, clusterName:%s, namespaceName:%s", appId, env, clusterName, namespaceName));
            }
            throw e;
        }
        return namespaceDTO.getId();
    }

    private ItemChangeSets parseChangeSets(NamespaceIdentifier namespace, List<ItemDTO> sourceItems) {
        ItemChangeSets changeSets = new ItemChangeSets();
        List<ItemDTO> targetItems = this.itemAPI.findItems(namespace.getAppId(), namespace.getEnv(), namespace.getClusterName(), namespace.getNamespaceName());
        long namespaceId = this.getNamespaceId(namespace);
        if (CollectionUtils.isEmpty(targetItems)) {
            int lineNum = 1;
            for (ItemDTO sourceItem : sourceItems) {
                changeSets.addCreateItem(this.buildItem(namespaceId, lineNum++, sourceItem));
            }
        } else {
            Map targetItemMap = BeanUtils.mapByKey((String)"key", targetItems);
            ItemDTO targetItem = null;
            int maxLineNum = targetItems.size();
            for (ItemDTO sourceItem : sourceItems) {
                String key = sourceItem.getKey();
                String sourceValue = sourceItem.getValue();
                String sourceComment = sourceItem.getComment();
                targetItem = (ItemDTO)targetItemMap.get(key);
                if (targetItem == null) {
                    changeSets.addCreateItem(this.buildItem(namespaceId, ++maxLineNum, sourceItem));
                    continue;
                }
                if (!this.isModified(sourceValue, targetItem.getValue(), sourceComment, targetItem.getComment())) continue;
                targetItem.setValue(sourceValue);
                targetItem.setComment(sourceComment);
                changeSets.addUpdateItem(targetItem);
            }
        }
        return changeSets;
    }

    private ItemDTO buildItem(long namespaceId, int lineNum, ItemDTO sourceItem) {
        ItemDTO createdItem = new ItemDTO();
        BeanUtils.copyEntityProperties((Object)sourceItem, (Object)createdItem);
        createdItem.setLineNum(lineNum);
        createdItem.setNamespaceId(namespaceId);
        return createdItem;
    }

    private ItemDTO buildNormalItem(Long id, Long namespaceId, String key, String value, String comment, int lineNum) {
        ItemDTO item = new ItemDTO(key, value, comment, lineNum);
        item.setId(id.longValue());
        item.setNamespaceId(namespaceId.longValue());
        return item;
    }

    private boolean isModified(String sourceValue, String targetValue, String sourceComment, String targetComment) {
        if (!sourceValue.equals(targetValue)) {
            return true;
        }
        if (sourceComment == null) {
            return !StringUtils.isEmpty((String)targetComment);
        }
        if (targetComment != null) {
            return !sourceComment.equals(targetComment);
        }
        return false;
    }
}

