/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.portal.entity.bo.UserInfo;
import com.ctrip.framework.apollo.portal.entity.po.Favorite;
import com.ctrip.framework.apollo.portal.repository.FavoriteRepository;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.portal.spi.UserService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FavoriteService {
    public static final long POSITION_DEFAULT = 10000L;
    private final UserInfoHolder userInfoHolder;
    private final FavoriteRepository favoriteRepository;
    private final UserService userService;

    public FavoriteService(UserInfoHolder userInfoHolder, FavoriteRepository favoriteRepository, UserService userService) {
        this.userInfoHolder = userInfoHolder;
        this.favoriteRepository = favoriteRepository;
        this.userService = userService;
    }

    public Favorite addFavorite(Favorite favorite) {
        UserInfo user = this.userService.findByUserId(favorite.getUserId());
        if (user == null) {
            throw new BadRequestException("user not exist");
        }
        UserInfo loginUser = this.userInfoHolder.getUser();
        if (!loginUser.equals(user)) {
            throw new BadRequestException("add favorite fail. because favorite's user is not current login user.");
        }
        Favorite checkedFavorite = this.favoriteRepository.findByUserIdAndAppId(loginUser.getUserId(), favorite.getAppId());
        if (checkedFavorite != null) {
            return checkedFavorite;
        }
        favorite.setPosition(10000L);
        favorite.setDataChangeCreatedBy(user.getUserId());
        favorite.setDataChangeLastModifiedBy(user.getUserId());
        return (Favorite)((Object)this.favoriteRepository.save((Object)favorite));
    }

    public List<Favorite> search(String userId, String appId, Pageable page) {
        UserInfo loginUser;
        boolean isUserIdEmpty = StringUtils.isEmpty((Object)userId);
        boolean isAppIdEmpty = StringUtils.isEmpty((Object)appId);
        if (isAppIdEmpty && isUserIdEmpty) {
            throw new BadRequestException("user id and app id can't be empty at the same time");
        }
        if (!isUserIdEmpty && !Objects.equals((loginUser = this.userInfoHolder.getUser()).getUserId(), userId)) {
            userId = loginUser.getUserId();
        }
        if (isAppIdEmpty && !isUserIdEmpty) {
            return this.favoriteRepository.findByUserIdOrderByPositionAscDataChangeCreatedTimeAsc(userId, page);
        }
        if (!isAppIdEmpty && isUserIdEmpty) {
            return this.favoriteRepository.findByAppIdOrderByPositionAscDataChangeCreatedTimeAsc(appId, page);
        }
        return Arrays.asList(this.favoriteRepository.findByUserIdAndAppId(userId, appId));
    }

    public void deleteFavorite(long favoriteId) {
        Favorite favorite = this.favoriteRepository.findById(favoriteId).orElse(null);
        this.checkUserOperatePermission(favorite);
        this.favoriteRepository.delete((Object)favorite);
    }

    public void adjustFavoriteToFirst(long favoriteId) {
        Favorite favorite = this.favoriteRepository.findById(favoriteId).orElse(null);
        this.checkUserOperatePermission(favorite);
        String userId = favorite.getUserId();
        Favorite firstFavorite = this.favoriteRepository.findFirstByUserIdOrderByPositionAscDataChangeCreatedTimeAsc(userId);
        long minPosition = firstFavorite.getPosition();
        favorite.setPosition(minPosition - 1L);
        this.favoriteRepository.save((Object)favorite);
    }

    private void checkUserOperatePermission(Favorite favorite) {
        if (favorite == null) {
            throw new BadRequestException("favorite not exist");
        }
        if (!Objects.equals(this.userInfoHolder.getUser().getUserId(), favorite.getUserId())) {
            throw new BadRequestException("can not operate other person's favorite");
        }
    }

    public void batchDeleteByAppId(String appId, String operator) {
        this.favoriteRepository.batchDeleteByAppId(appId, operator);
    }
}

