/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.dto.NamespaceDTO;
import com.ctrip.framework.apollo.common.exception.ServiceException;
import com.ctrip.framework.apollo.portal.component.PermissionValidator;
import com.ctrip.framework.apollo.portal.entity.model.NamespaceTextModel;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.ItemService;
import com.ctrip.framework.apollo.portal.service.NamespaceService;
import com.ctrip.framework.apollo.portal.util.ConfigFileUtils;
import com.ctrip.framework.apollo.portal.util.ConfigToFileUtils;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ConfigsImportService {
    private final ItemService itemService;
    private final NamespaceService namespaceService;
    private final PermissionValidator permissionValidator;

    public ConfigsImportService(ItemService itemService, @Lazy NamespaceService namespaceService, PermissionValidator permissionValidator) {
        this.itemService = itemService;
        this.namespaceService = namespaceService;
        this.permissionValidator = permissionValidator;
    }

    private void importConfig(String appId, String env, String clusterName, String namespaceName, long namespaceId, String format, String configText) {
        NamespaceTextModel model = new NamespaceTextModel();
        model.setAppId(appId);
        model.setEnv(env);
        model.setClusterName(clusterName);
        model.setNamespaceName(namespaceName);
        model.setNamespaceId(namespaceId);
        model.setFormat(format);
        model.setConfigText(configText);
        this.itemService.updateConfigItemByText(model);
    }

    private void importOneConfigFromFile(String appId, String env, String clusterName, String namespaceName, String configText, String format) {
        NamespaceDTO namespaceDTO = this.namespaceService.loadNamespaceBaseInfo(appId, Env.valueOf(env), clusterName, namespaceName);
        this.importConfig(appId, env, clusterName, namespaceName, namespaceDTO.getId(), format, configText);
    }

    private void importOneConfigFromText(String env, String standardFilename, String configText) {
        String appId = ConfigFileUtils.getAppId(standardFilename);
        String clusterName = ConfigFileUtils.getClusterName(standardFilename);
        String namespace = ConfigFileUtils.getNamespace(standardFilename);
        String format = ConfigFileUtils.getFormat(standardFilename);
        this.importOneConfigFromFile(appId, env, clusterName, namespace, configText, format);
    }

    public void importOneConfigFromFile(String env, String standardFilename, InputStream inputStream) {
        String configText;
        try (InputStream in = inputStream;){
            configText = ConfigToFileUtils.fileToString(in);
        }
        catch (IOException e) {
            throw new ServiceException("Read config file errors:{}", (Exception)e);
        }
        this.importOneConfigFromText(env, standardFilename, configText);
    }
}

