/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.dto.ClusterDTO;
import com.ctrip.framework.apollo.common.entity.App;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.portal.component.PermissionValidator;
import com.ctrip.framework.apollo.portal.component.PortalSettings;
import com.ctrip.framework.apollo.portal.entity.bo.ConfigBO;
import com.ctrip.framework.apollo.portal.entity.bo.NamespaceBO;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.AppService;
import com.ctrip.framework.apollo.portal.service.ClusterService;
import com.ctrip.framework.apollo.portal.service.NamespaceService;
import com.ctrip.framework.apollo.portal.util.ConfigFileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ConfigsExportService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigsExportService.class);
    private final AppService appService;
    private final ClusterService clusterService;
    private final NamespaceService namespaceService;
    private final PortalSettings portalSettings;
    private final PermissionValidator permissionValidator;

    public ConfigsExportService(AppService appService, ClusterService clusterService, @Lazy NamespaceService namespaceService, PortalSettings portalSettings, PermissionValidator permissionValidator) {
        this.appService = appService;
        this.clusterService = clusterService;
        this.namespaceService = namespaceService;
        this.portalSettings = portalSettings;
        this.permissionValidator = permissionValidator;
    }

    private static void writeAsZipOutputStream(Stream<ConfigBO> configBOStream, OutputStream outputStream) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            Consumer<ConfigBO> configBOConsumer = configBO -> {
                try {
                    ZipOutputStream zipOutputStream2 = zipOutputStream;
                    synchronized (zipOutputStream2) {
                        ConfigsExportService.write2ZipOutputStream(zipOutputStream, configBO);
                    }
                }
                catch (IOException e) {
                    logger.error("Write error. {}", configBO);
                    throw new IllegalStateException(e);
                }
            };
            configBOStream.forEach(configBOConsumer);
        }
    }

    private static ZipOutputStream write2ZipOutputStream(ZipOutputStream zipOutputStream, ConfigBO configBO) throws IOException {
        Env env = configBO.getEnv();
        String ownerName = configBO.getOwnerName();
        String appId = configBO.getAppId();
        String clusterName = configBO.getClusterName();
        String namespace = configBO.getNamespace();
        String configFileContent = configBO.getConfigFileContent();
        ConfigFileFormat configFileFormat = configBO.getFormat();
        String configFilename = ConfigFileUtils.toFilename(appId, clusterName, namespace, configFileFormat);
        String filePath = ConfigFileUtils.toFilePath(ownerName, appId, env, configFilename);
        ZipEntry zipEntry = new ZipEntry(filePath);
        try {
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(configFileContent.getBytes());
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            logger.error("config export failed. {}", (Object)configBO);
            throw new IOException("config export failed", e);
        }
        return zipOutputStream;
    }

    private Stream<ConfigBO> makeStreamBy(Env env, String ownerName, String appId, String clusterName) {
        List<NamespaceBO> namespaceBOS = this.namespaceService.findNamespaceBOs(appId, env, clusterName);
        Function<NamespaceBO, ConfigBO> function = namespaceBO -> new ConfigBO(env, ownerName, appId, clusterName, (NamespaceBO)namespaceBO);
        return namespaceBOS.parallelStream().map(function);
    }

    private Stream<ConfigBO> makeStreamBy(Env env, String ownerName, String appId) {
        List<ClusterDTO> clusterDTOS = this.clusterService.findClusters(env, appId);
        Function<ClusterDTO, Stream> function = clusterDTO -> this.makeStreamBy(env, ownerName, appId, clusterDTO.getName());
        return clusterDTOS.parallelStream().flatMap(function);
    }

    private Stream<ConfigBO> makeStreamBy(Env env, List<App> apps) {
        Function<App, Stream> function = app -> this.makeStreamBy(env, app.getOwnerName(), app.getAppId());
        return apps.parallelStream().flatMap(function);
    }

    private Stream<ConfigBO> makeStreamBy(Collection<Env> envs) {
        List<App> apps = this.appService.findAll();
        Predicate<App> isAppAdmin = app -> {
            try {
                return this.permissionValidator.isAppAdmin(app.getAppId());
            }
            catch (Exception e) {
                logger.error("app = {}", app);
                logger.error(app.getAppId());
                return false;
            }
        };
        List appsExistPermission = apps.stream().filter(isAppAdmin).collect(Collectors.toList());
        return envs.parallelStream().flatMap(env -> this.makeStreamBy((Env)env, appsExistPermission));
    }

    public void exportAllTo(OutputStream outputStream) throws IOException {
        List<Env> activeEnvs = this.portalSettings.getActiveEnvs();
        Stream<ConfigBO> configBOStream = this.makeStreamBy(activeEnvs);
        ConfigsExportService.writeAsZipOutputStream(configBOStream, outputStream);
    }
}

