/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.dto.ClusterDTO;
import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.tracer.Tracer;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ClusterService {
    private final UserInfoHolder userInfoHolder;
    private final AdminServiceAPI.ClusterAPI clusterAPI;

    public ClusterService(UserInfoHolder userInfoHolder, AdminServiceAPI.ClusterAPI clusterAPI) {
        this.userInfoHolder = userInfoHolder;
        this.clusterAPI = clusterAPI;
    }

    public List<ClusterDTO> findClusters(Env env, String appId) {
        return this.clusterAPI.findClustersByApp(appId, env);
    }

    public ClusterDTO createCluster(Env env, ClusterDTO cluster) {
        if (!this.clusterAPI.isClusterUnique(cluster.getAppId(), env, cluster.getName())) {
            throw new BadRequestException(String.format("cluster %s already exists.", cluster.getName()));
        }
        ClusterDTO clusterDTO = this.clusterAPI.create(env, cluster);
        Tracer.logEvent((String)"Cluster.Create", (String)cluster.getAppId(), (String)"0", (String)cluster.getName());
        return clusterDTO;
    }

    public void deleteCluster(Env env, String appId, String clusterName) {
        this.clusterAPI.delete(env, appId, clusterName, this.userInfoHolder.getUser().getUserId());
    }

    public ClusterDTO loadCluster(String appId, Env env, String clusterName) {
        return this.clusterAPI.loadCluster(appId, env, clusterName);
    }
}

