/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.dto.AppDTO;
import com.ctrip.framework.apollo.common.dto.PageDTO;
import com.ctrip.framework.apollo.common.entity.App;
import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.entity.bo.UserInfo;
import com.ctrip.framework.apollo.portal.entity.vo.EnvClusterInfo;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.repository.AppRepository;
import com.ctrip.framework.apollo.portal.service.AppNamespaceService;
import com.ctrip.framework.apollo.portal.service.ClusterService;
import com.ctrip.framework.apollo.portal.service.FavoriteService;
import com.ctrip.framework.apollo.portal.service.RoleInitializationService;
import com.ctrip.framework.apollo.portal.service.RolePermissionService;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.portal.spi.UserService;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppService {
    private final UserInfoHolder userInfoHolder;
    private final AdminServiceAPI.AppAPI appAPI;
    private final AppRepository appRepository;
    private final ClusterService clusterService;
    private final AppNamespaceService appNamespaceService;
    private final RoleInitializationService roleInitializationService;
    private final RolePermissionService rolePermissionService;
    private final FavoriteService favoriteService;
    private final UserService userService;

    public AppService(UserInfoHolder userInfoHolder, AdminServiceAPI.AppAPI appAPI, AppRepository appRepository, ClusterService clusterService, AppNamespaceService appNamespaceService, RoleInitializationService roleInitializationService, RolePermissionService rolePermissionService, FavoriteService favoriteService, UserService userService) {
        this.userInfoHolder = userInfoHolder;
        this.appAPI = appAPI;
        this.appRepository = appRepository;
        this.clusterService = clusterService;
        this.appNamespaceService = appNamespaceService;
        this.roleInitializationService = roleInitializationService;
        this.rolePermissionService = rolePermissionService;
        this.favoriteService = favoriteService;
        this.userService = userService;
    }

    public List<App> findAll() {
        Iterable apps = this.appRepository.findAll();
        if (apps == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)apps);
    }

    public PageDTO<App> findAll(Pageable pageable) {
        Page apps = this.appRepository.findAll(pageable);
        return new PageDTO(apps.getContent(), pageable, apps.getTotalElements());
    }

    public PageDTO<App> searchByAppIdOrAppName(String query, Pageable pageable) {
        Page<App> apps = this.appRepository.findByAppIdContainingOrNameContaining(query, query, pageable);
        return new PageDTO(apps.getContent(), pageable, apps.getTotalElements());
    }

    public List<App> findByAppIds(Set<String> appIds) {
        return this.appRepository.findByAppIdIn(appIds);
    }

    public List<App> findByAppIds(Set<String> appIds, Pageable pageable) {
        return this.appRepository.findByAppIdIn(appIds, pageable);
    }

    public List<App> findByOwnerName(String ownerName, Pageable page) {
        return this.appRepository.findByOwnerName(ownerName, page);
    }

    public App load(String appId) {
        return this.appRepository.findByAppId(appId);
    }

    public AppDTO load(Env env, String appId) {
        return this.appAPI.loadApp(env, appId);
    }

    public void createAppInRemote(Env env, App app) {
        String username = this.userInfoHolder.getUser().getUserId();
        app.setDataChangeCreatedBy(username);
        app.setDataChangeLastModifiedBy(username);
        AppDTO appDTO = (AppDTO)BeanUtils.transform(AppDTO.class, (Object)app);
        this.appAPI.createApp(env, appDTO);
    }

    @Transactional
    public App createAppInLocal(App app) {
        String appId = app.getAppId();
        App managedApp = this.appRepository.findByAppId(appId);
        if (managedApp != null) {
            throw new BadRequestException(String.format("App already exists. AppId = %s", appId));
        }
        UserInfo owner = this.userService.findByUserId(app.getOwnerName());
        if (owner == null) {
            throw new BadRequestException("Application's owner not exist.");
        }
        app.setOwnerEmail(owner.getEmail());
        String operator = this.userInfoHolder.getUser().getUserId();
        app.setDataChangeCreatedBy(operator);
        app.setDataChangeLastModifiedBy(operator);
        App createdApp = (App)this.appRepository.save(app);
        this.appNamespaceService.createDefaultAppNamespace(appId);
        this.roleInitializationService.initAppRoles(createdApp);
        Tracer.logEvent((String)"App.Create", (String)appId);
        return createdApp;
    }

    @Transactional
    public App updateAppInLocal(App app) {
        String appId = app.getAppId();
        App managedApp = this.appRepository.findByAppId(appId);
        if (managedApp == null) {
            throw new BadRequestException(String.format("App not exists. AppId = %s", appId));
        }
        managedApp.setName(app.getName());
        managedApp.setOrgId(app.getOrgId());
        managedApp.setOrgName(app.getOrgName());
        String ownerName = app.getOwnerName();
        UserInfo owner = this.userService.findByUserId(ownerName);
        if (owner == null) {
            throw new BadRequestException(String.format("App's owner not exists. owner = %s", ownerName));
        }
        managedApp.setOwnerName(owner.getUserId());
        managedApp.setOwnerEmail(owner.getEmail());
        String operator = this.userInfoHolder.getUser().getUserId();
        managedApp.setDataChangeLastModifiedBy(operator);
        return (App)this.appRepository.save(managedApp);
    }

    public EnvClusterInfo createEnvNavNode(Env env, String appId) {
        EnvClusterInfo node = new EnvClusterInfo(env);
        node.setClusters(this.clusterService.findClusters(env, appId));
        return node;
    }

    @Transactional
    public App deleteAppInLocal(String appId) {
        App managedApp = this.appRepository.findByAppId(appId);
        if (managedApp == null) {
            throw new BadRequestException(String.format("App not exists. AppId = %s", appId));
        }
        String operator = this.userInfoHolder.getUser().getUserId();
        managedApp.setDataChangeLastModifiedBy(operator);
        this.appRepository.deleteApp(appId, operator);
        this.appNamespaceService.batchDeleteByAppId(appId, operator);
        this.favoriteService.batchDeleteByAppId(appId, operator);
        this.rolePermissionService.deleteRolePermissionsByAppId(appId, operator);
        return managedApp;
    }
}

