/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.entity.App;
import com.ctrip.framework.apollo.common.entity.AppNamespace;
import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.portal.repository.AppNamespaceRepository;
import com.ctrip.framework.apollo.portal.service.AppService;
import com.ctrip.framework.apollo.portal.service.RoleInitializationService;
import com.ctrip.framework.apollo.portal.service.RolePermissionService;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AppNamespaceService {
    private static final int PRIVATE_APP_NAMESPACE_NOTIFICATION_COUNT = 5;
    private static final Joiner APP_NAMESPACE_JOINER = Joiner.on((String)",").skipNulls();
    private final UserInfoHolder userInfoHolder;
    private final AppNamespaceRepository appNamespaceRepository;
    private final RoleInitializationService roleInitializationService;
    private final AppService appService;
    private final RolePermissionService rolePermissionService;

    public AppNamespaceService(UserInfoHolder userInfoHolder, AppNamespaceRepository appNamespaceRepository, RoleInitializationService roleInitializationService, @Lazy AppService appService, RolePermissionService rolePermissionService) {
        this.userInfoHolder = userInfoHolder;
        this.appNamespaceRepository = appNamespaceRepository;
        this.roleInitializationService = roleInitializationService;
        this.appService = appService;
        this.rolePermissionService = rolePermissionService;
    }

    public List<AppNamespace> findPublicAppNamespaces() {
        return this.appNamespaceRepository.findByIsPublicTrue();
    }

    public AppNamespace findPublicAppNamespace(String namespaceName) {
        List<AppNamespace> appNamespaces = this.appNamespaceRepository.findByNameAndIsPublic(namespaceName, true);
        if (CollectionUtils.isEmpty(appNamespaces)) {
            return null;
        }
        return appNamespaces.get(0);
    }

    private List<AppNamespace> findAllPrivateAppNamespaces(String namespaceName) {
        return this.appNamespaceRepository.findByNameAndIsPublic(namespaceName, false);
    }

    public AppNamespace findByAppIdAndName(String appId, String namespaceName) {
        return this.appNamespaceRepository.findByAppIdAndName(appId, namespaceName);
    }

    public List<AppNamespace> findByAppId(String appId) {
        return this.appNamespaceRepository.findByAppId(appId);
    }

    @Transactional
    public void createDefaultAppNamespace(String appId) {
        if (!this.isAppNamespaceNameUnique(appId, "application")) {
            throw new BadRequestException(String.format("App already has application namespace. AppId = %s", appId));
        }
        AppNamespace appNs = new AppNamespace();
        appNs.setAppId(appId);
        appNs.setName("application");
        appNs.setComment("default app namespace");
        appNs.setFormat(ConfigFileFormat.Properties.getValue());
        String userId = this.userInfoHolder.getUser().getUserId();
        appNs.setDataChangeCreatedBy(userId);
        appNs.setDataChangeLastModifiedBy(userId);
        this.appNamespaceRepository.save(appNs);
    }

    public boolean isAppNamespaceNameUnique(String appId, String namespaceName) {
        Objects.requireNonNull(appId, "AppId must not be null");
        Objects.requireNonNull(namespaceName, "Namespace must not be null");
        return Objects.isNull(this.appNamespaceRepository.findByAppIdAndName(appId, namespaceName));
    }

    public AppNamespace createAppNamespaceInLocal(AppNamespace appNamespace) {
        return this.createAppNamespaceInLocal(appNamespace, true);
    }

    @Transactional
    public AppNamespace createAppNamespaceInLocal(AppNamespace appNamespace, boolean appendNamespacePrefix) {
        String appId = appNamespace.getAppId();
        App app = this.appService.load(appId);
        if (app == null) {
            throw new BadRequestException("App not exist. AppId = " + appId);
        }
        if (appNamespace.isPublic()) {
            appNamespace.setFormat(ConfigFileFormat.Properties.getValue());
        }
        StringBuilder appNamespaceName = new StringBuilder();
        appNamespaceName.append(appNamespace.isPublic() && appendNamespacePrefix ? app.getOrgId() + "." : "").append(appNamespace.getName()).append(appNamespace.formatAsEnum() == ConfigFileFormat.Properties ? "" : "." + appNamespace.getFormat());
        appNamespace.setName(appNamespaceName.toString());
        if (appNamespace.getComment() == null) {
            appNamespace.setComment("");
        }
        if (!ConfigFileFormat.isValidFormat((String)appNamespace.getFormat())) {
            throw new BadRequestException("Invalid namespace format. format must be properties\u3001json\u3001yaml\u3001yml\u3001xml");
        }
        String operator = appNamespace.getDataChangeCreatedBy();
        if (StringUtils.isEmpty((String)operator)) {
            operator = this.userInfoHolder.getUser().getUserId();
            appNamespace.setDataChangeCreatedBy(operator);
        }
        appNamespace.setDataChangeLastModifiedBy(operator);
        if (appNamespace.isPublic()) {
            this.checkAppNamespaceGlobalUniqueness(appNamespace);
        } else {
            if (this.appNamespaceRepository.findByAppIdAndName(appNamespace.getAppId(), appNamespace.getName()) != null) {
                throw new BadRequestException("Private AppNamespace " + appNamespace.getName() + " already exists!");
            }
            this.checkPublicAppNamespaceGlobalUniqueness(appNamespace);
        }
        AppNamespace createdAppNamespace = (AppNamespace)this.appNamespaceRepository.save(appNamespace);
        this.roleInitializationService.initNamespaceRoles(appNamespace.getAppId(), appNamespace.getName(), operator);
        this.roleInitializationService.initNamespaceEnvRoles(appNamespace.getAppId(), appNamespace.getName(), operator);
        return createdAppNamespace;
    }

    private void checkAppNamespaceGlobalUniqueness(AppNamespace appNamespace) {
        this.checkPublicAppNamespaceGlobalUniqueness(appNamespace);
        List<AppNamespace> privateAppNamespaces = this.findAllPrivateAppNamespaces(appNamespace.getName());
        if (!CollectionUtils.isEmpty(privateAppNamespaces)) {
            HashSet appIds = Sets.newHashSet();
            for (AppNamespace ans : privateAppNamespaces) {
                appIds.add(ans.getAppId());
                if (appIds.size() != 5) continue;
                break;
            }
            throw new BadRequestException("Public AppNamespace " + appNamespace.getName() + " already exists as private AppNamespace in appId: " + APP_NAMESPACE_JOINER.join((Iterable)appIds) + ", etc. Please select another name!");
        }
    }

    private void checkPublicAppNamespaceGlobalUniqueness(AppNamespace appNamespace) {
        AppNamespace publicAppNamespace = this.findPublicAppNamespace(appNamespace.getName());
        if (publicAppNamespace != null) {
            throw new BadRequestException("AppNamespace " + appNamespace.getName() + " already exists as public namespace in appId: " + publicAppNamespace.getAppId() + "!");
        }
    }

    @Transactional
    public AppNamespace deleteAppNamespace(String appId, String namespaceName) {
        AppNamespace appNamespace = this.appNamespaceRepository.findByAppIdAndName(appId, namespaceName);
        if (appNamespace == null) {
            throw new BadRequestException(String.format("AppNamespace not exists. AppId = %s, NamespaceName = %s", appId, namespaceName));
        }
        String operator = this.userInfoHolder.getUser().getUserId();
        appNamespace.setDataChangeLastModifiedBy(operator);
        this.appNamespaceRepository.delete(appId, namespaceName, operator);
        this.rolePermissionService.deleteRolePermissionsByAppIdAndNamespace(appId, namespaceName, operator);
        return appNamespace;
    }

    public void batchDeleteByAppId(String appId, String operator) {
        this.appNamespaceRepository.batchDeleteByAppId(appId, operator);
    }
}

