/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.service;

import com.ctrip.framework.apollo.common.dto.AccessKeyDTO;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.tracer.Tracer;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AccessKeyService {
    private final AdminServiceAPI.AccessKeyAPI accessKeyAPI;

    public AccessKeyService(AdminServiceAPI.AccessKeyAPI accessKeyAPI) {
        this.accessKeyAPI = accessKeyAPI;
    }

    public List<AccessKeyDTO> findByAppId(Env env, String appId) {
        return this.accessKeyAPI.findByAppId(env, appId);
    }

    public AccessKeyDTO createAccessKey(Env env, AccessKeyDTO accessKey) {
        AccessKeyDTO accessKeyDTO = this.accessKeyAPI.create(env, accessKey);
        Tracer.logEvent((String)"AccessKey.Create", (String)accessKey.getAppId());
        return accessKeyDTO;
    }

    public void deleteAccessKey(Env env, String appId, long id, String operator) {
        this.accessKeyAPI.delete(env, appId, id, operator);
    }

    public void enable(Env env, String appId, long id, String operator) {
        this.accessKeyAPI.enable(env, appId, id, operator);
    }

    public void disable(Env env, String appId, long id, String operator) {
        this.accessKeyAPI.disable(env, appId, id, operator);
    }
}

