/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.listener;

import com.ctrip.framework.apollo.common.dto.AppDTO;
import com.ctrip.framework.apollo.common.dto.AppNamespaceDTO;
import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.component.PortalSettings;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.listener.AppDeletionEvent;
import com.ctrip.framework.apollo.portal.listener.AppNamespaceDeletionEvent;
import com.ctrip.framework.apollo.tracer.Tracer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class DeletionListener {
    private static final Logger logger = LoggerFactory.getLogger(DeletionListener.class);
    private final PortalSettings portalSettings;
    private final AdminServiceAPI.AppAPI appAPI;
    private final AdminServiceAPI.NamespaceAPI namespaceAPI;

    public DeletionListener(PortalSettings portalSettings, AdminServiceAPI.AppAPI appAPI, AdminServiceAPI.NamespaceAPI namespaceAPI) {
        this.portalSettings = portalSettings;
        this.appAPI = appAPI;
        this.namespaceAPI = namespaceAPI;
    }

    @EventListener
    public void onAppDeletionEvent(AppDeletionEvent event) {
        AppDTO appDTO = (AppDTO)BeanUtils.transform(AppDTO.class, (Object)event.getApp());
        String appId = appDTO.getAppId();
        String operator = appDTO.getDataChangeLastModifiedBy();
        List<Env> envs = this.portalSettings.getActiveEnvs();
        for (Env env : envs) {
            try {
                this.appAPI.deleteApp(env, appId, operator);
            }
            catch (Throwable e) {
                logger.error("Delete app failed. Env = {}, AppId = {}", new Object[]{env, appId, e});
                Tracer.logError((String)String.format("Delete app failed. Env = %s, AppId = %s", env, appId), (Throwable)e);
            }
        }
    }

    @EventListener
    public void onAppNamespaceDeletionEvent(AppNamespaceDeletionEvent event) {
        AppNamespaceDTO appNamespace = (AppNamespaceDTO)BeanUtils.transform(AppNamespaceDTO.class, (Object)event.getAppNamespace());
        List<Env> envs = this.portalSettings.getActiveEnvs();
        String appId = appNamespace.getAppId();
        String namespaceName = appNamespace.getName();
        String operator = appNamespace.getDataChangeLastModifiedBy();
        for (Env env : envs) {
            try {
                this.namespaceAPI.deleteAppNamespace(env, appId, namespaceName, operator);
            }
            catch (Throwable e) {
                logger.error("Delete appNamespace failed. appId = {}, namespace = {}, env = {}", new Object[]{appId, namespaceName, env, e});
                Tracer.logError((String)String.format("Delete appNamespace failed. appId = %s, namespace = %s, env = %s", appId, namespaceName, env), (Throwable)e);
            }
        }
    }
}

