/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.listener;

import com.ctrip.framework.apollo.common.dto.AppDTO;
import com.ctrip.framework.apollo.common.dto.AppNamespaceDTO;
import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.component.PortalSettings;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.listener.AppCreationEvent;
import com.ctrip.framework.apollo.portal.listener.AppNamespaceCreationEvent;
import com.ctrip.framework.apollo.tracer.Tracer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class CreationListener {
    private static Logger logger = LoggerFactory.getLogger(CreationListener.class);
    private final PortalSettings portalSettings;
    private final AdminServiceAPI.AppAPI appAPI;
    private final AdminServiceAPI.NamespaceAPI namespaceAPI;

    public CreationListener(PortalSettings portalSettings, AdminServiceAPI.AppAPI appAPI, AdminServiceAPI.NamespaceAPI namespaceAPI) {
        this.portalSettings = portalSettings;
        this.appAPI = appAPI;
        this.namespaceAPI = namespaceAPI;
    }

    @EventListener
    public void onAppCreationEvent(AppCreationEvent event) {
        AppDTO appDTO = (AppDTO)BeanUtils.transform(AppDTO.class, (Object)event.getApp());
        List<Env> envs = this.portalSettings.getActiveEnvs();
        for (Env env : envs) {
            try {
                this.appAPI.createApp(env, appDTO);
            }
            catch (Throwable e) {
                logger.error("Create app failed. appId = {}, env = {})", new Object[]{appDTO.getAppId(), env, e});
                Tracer.logError((String)String.format("Create app failed. appId = %s, env = %s", appDTO.getAppId(), env), (Throwable)e);
            }
        }
    }

    @EventListener
    public void onAppNamespaceCreationEvent(AppNamespaceCreationEvent event) {
        AppNamespaceDTO appNamespace = (AppNamespaceDTO)BeanUtils.transform(AppNamespaceDTO.class, (Object)event.getAppNamespace());
        List<Env> envs = this.portalSettings.getActiveEnvs();
        for (Env env : envs) {
            try {
                this.namespaceAPI.createAppNamespace(env, appNamespace);
            }
            catch (Throwable e) {
                logger.error("Create appNamespace failed. appId = {}, env = {}", new Object[]{appNamespace.getAppId(), env, e});
                Tracer.logError((String)String.format("Create appNamespace failed. appId = %s, env = %s", appNamespace.getAppId(), env), (Throwable)e);
            }
        }
    }
}

