/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.listener;

import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.component.emailbuilder.GrayPublishEmailBuilder;
import com.ctrip.framework.apollo.portal.component.emailbuilder.MergeEmailBuilder;
import com.ctrip.framework.apollo.portal.component.emailbuilder.NormalPublishEmailBuilder;
import com.ctrip.framework.apollo.portal.component.emailbuilder.RollbackEmailBuilder;
import com.ctrip.framework.apollo.portal.entity.bo.Email;
import com.ctrip.framework.apollo.portal.entity.bo.ReleaseHistoryBO;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.listener.ConfigPublishEvent;
import com.ctrip.framework.apollo.portal.service.ReleaseHistoryService;
import com.ctrip.framework.apollo.portal.spi.EmailService;
import com.ctrip.framework.apollo.portal.spi.MQService;
import com.ctrip.framework.apollo.tracer.Tracer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ConfigPublishListener {
    private final ReleaseHistoryService releaseHistoryService;
    private final EmailService emailService;
    private final NormalPublishEmailBuilder normalPublishEmailBuilder;
    private final GrayPublishEmailBuilder grayPublishEmailBuilder;
    private final RollbackEmailBuilder rollbackEmailBuilder;
    private final MergeEmailBuilder mergeEmailBuilder;
    private final PortalConfig portalConfig;
    private final MQService mqService;
    private ExecutorService executorService;

    public ConfigPublishListener(ReleaseHistoryService releaseHistoryService, EmailService emailService, NormalPublishEmailBuilder normalPublishEmailBuilder, GrayPublishEmailBuilder grayPublishEmailBuilder, RollbackEmailBuilder rollbackEmailBuilder, MergeEmailBuilder mergeEmailBuilder, PortalConfig portalConfig, MQService mqService) {
        this.releaseHistoryService = releaseHistoryService;
        this.emailService = emailService;
        this.normalPublishEmailBuilder = normalPublishEmailBuilder;
        this.grayPublishEmailBuilder = grayPublishEmailBuilder;
        this.rollbackEmailBuilder = rollbackEmailBuilder;
        this.mergeEmailBuilder = mergeEmailBuilder;
        this.portalConfig = portalConfig;
        this.mqService = mqService;
    }

    @PostConstruct
    public void init() {
        this.executorService = Executors.newSingleThreadExecutor(ApolloThreadFactory.create((String)"ConfigPublishNotify", (boolean)true));
    }

    @EventListener
    public void onConfigPublish(ConfigPublishEvent event) {
        this.executorService.submit(new ConfigPublishNotifyTask(event.getConfigPublishInfo()));
    }

    private class ConfigPublishNotifyTask
    implements Runnable {
        private ConfigPublishEvent.ConfigPublishInfo publishInfo;

        ConfigPublishNotifyTask(ConfigPublishEvent.ConfigPublishInfo publishInfo) {
            this.publishInfo = publishInfo;
        }

        @Override
        public void run() {
            ReleaseHistoryBO releaseHistory = this.getReleaseHistory();
            if (releaseHistory == null) {
                Tracer.logError((String)"Load release history failed", null);
                return;
            }
            this.sendPublishEmail(releaseHistory);
            this.sendPublishMsg(releaseHistory);
        }

        private ReleaseHistoryBO getReleaseHistory() {
            int operation;
            Env env = this.publishInfo.getEnv();
            int n = this.publishInfo.isMergeEvent() ? 4 : (this.publishInfo.isRollbackEvent() ? 1 : (this.publishInfo.isNormalPublishEvent() ? 0 : (operation = this.publishInfo.isGrayPublishEvent() ? 2 : -1)));
            if (operation == -1) {
                return null;
            }
            if (this.publishInfo.isRollbackEvent()) {
                return ConfigPublishListener.this.releaseHistoryService.findLatestByPreviousReleaseIdAndOperation(env, this.publishInfo.getPreviousReleaseId(), operation);
            }
            return ConfigPublishListener.this.releaseHistoryService.findLatestByReleaseIdAndOperation(env, this.publishInfo.getReleaseId(), operation);
        }

        private void sendPublishEmail(ReleaseHistoryBO releaseHistory) {
            Env env = this.publishInfo.getEnv();
            if (!ConfigPublishListener.this.portalConfig.emailSupportedEnvs().contains(env)) {
                return;
            }
            int realOperation = releaseHistory.getOperation();
            Email email = null;
            try {
                email = this.buildEmail(env, releaseHistory, realOperation);
            }
            catch (Throwable e) {
                Tracer.logError((String)"build email failed.", (Throwable)e);
            }
            if (email != null) {
                ConfigPublishListener.this.emailService.send(email);
            }
        }

        private void sendPublishMsg(ReleaseHistoryBO releaseHistory) {
            ConfigPublishListener.this.mqService.sendPublishMsg(this.publishInfo.getEnv(), releaseHistory);
        }

        private Email buildEmail(Env env, ReleaseHistoryBO releaseHistory, int operation) {
            switch (operation) {
                case 2: {
                    return ConfigPublishListener.this.grayPublishEmailBuilder.build(env, releaseHistory);
                }
                case 0: {
                    return ConfigPublishListener.this.normalPublishEmailBuilder.build(env, releaseHistory);
                }
                case 1: {
                    return ConfigPublishListener.this.rollbackEmailBuilder.build(env, releaseHistory);
                }
                case 4: {
                    return ConfigPublishListener.this.mergeEmailBuilder.build(env, releaseHistory);
                }
            }
            return null;
        }
    }
}

