/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.listener;

import com.ctrip.framework.apollo.portal.environment.Env;
import org.springframework.context.ApplicationEvent;

public class ConfigPublishEvent
extends ApplicationEvent {
    private ConfigPublishInfo configPublishInfo;

    public ConfigPublishEvent(Object source) {
        super(source);
        this.configPublishInfo = (ConfigPublishInfo)source;
    }

    public static ConfigPublishEvent instance() {
        ConfigPublishInfo info = new ConfigPublishInfo();
        return new ConfigPublishEvent(info);
    }

    public ConfigPublishInfo getConfigPublishInfo() {
        return this.configPublishInfo;
    }

    public ConfigPublishEvent withAppId(String appId) {
        this.configPublishInfo.setAppId(appId);
        return this;
    }

    public ConfigPublishEvent withCluster(String clusterName) {
        this.configPublishInfo.setClusterName(clusterName);
        return this;
    }

    public ConfigPublishEvent withNamespace(String namespaceName) {
        this.configPublishInfo.setNamespaceName(namespaceName);
        return this;
    }

    public ConfigPublishEvent withReleaseId(long releaseId) {
        this.configPublishInfo.setReleaseId(releaseId);
        return this;
    }

    public ConfigPublishEvent withPreviousReleaseId(long previousReleaseId) {
        this.configPublishInfo.setPreviousReleaseId(previousReleaseId);
        return this;
    }

    public ConfigPublishEvent setNormalPublishEvent(boolean isNormalPublishEvent) {
        this.configPublishInfo.setNormalPublishEvent(isNormalPublishEvent);
        return this;
    }

    public ConfigPublishEvent setGrayPublishEvent(boolean isGrayPublishEvent) {
        this.configPublishInfo.setGrayPublishEvent(isGrayPublishEvent);
        return this;
    }

    public ConfigPublishEvent setRollbackEvent(boolean isRollbackEvent) {
        this.configPublishInfo.setRollbackEvent(isRollbackEvent);
        return this;
    }

    public ConfigPublishEvent setMergeEvent(boolean isMergeEvent) {
        this.configPublishInfo.setMergeEvent(isMergeEvent);
        return this;
    }

    public ConfigPublishEvent setEnv(Env env) {
        this.configPublishInfo.setEnv(env);
        return this;
    }

    public static class ConfigPublishInfo {
        private String env;
        private String appId;
        private String clusterName;
        private String namespaceName;
        private long releaseId;
        private long previousReleaseId;
        private boolean isRollbackEvent;
        private boolean isMergeEvent;
        private boolean isNormalPublishEvent;
        private boolean isGrayPublishEvent;

        public Env getEnv() {
            return Env.valueOf(this.env);
        }

        public void setEnv(Env env) {
            this.env = env.toString();
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public String getNamespaceName() {
            return this.namespaceName;
        }

        public void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        public long getReleaseId() {
            return this.releaseId;
        }

        public void setReleaseId(long releaseId) {
            this.releaseId = releaseId;
        }

        public long getPreviousReleaseId() {
            return this.previousReleaseId;
        }

        public void setPreviousReleaseId(long previousReleaseId) {
            this.previousReleaseId = previousReleaseId;
        }

        public boolean isRollbackEvent() {
            return this.isRollbackEvent;
        }

        public void setRollbackEvent(boolean rollbackEvent) {
            this.isRollbackEvent = rollbackEvent;
        }

        public boolean isMergeEvent() {
            return this.isMergeEvent;
        }

        public void setMergeEvent(boolean mergeEvent) {
            this.isMergeEvent = mergeEvent;
        }

        public boolean isNormalPublishEvent() {
            return this.isNormalPublishEvent;
        }

        public void setNormalPublishEvent(boolean normalPublishEvent) {
            this.isNormalPublishEvent = normalPublishEvent;
        }

        public boolean isGrayPublishEvent() {
            return this.isGrayPublishEvent;
        }

        public void setGrayPublishEvent(boolean grayPublishEvent) {
            this.isGrayPublishEvent = grayPublishEvent;
        }
    }
}

