/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.listener;

import com.ctrip.framework.apollo.common.dto.AppDTO;
import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.component.PortalSettings;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.listener.AppInfoChangedEvent;
import com.ctrip.framework.apollo.tracer.Tracer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class AppInfoChangedListener {
    private static final Logger logger = LoggerFactory.getLogger(AppInfoChangedListener.class);
    private final AdminServiceAPI.AppAPI appAPI;
    private final PortalSettings portalSettings;

    public AppInfoChangedListener(AdminServiceAPI.AppAPI appAPI, PortalSettings portalSettings) {
        this.appAPI = appAPI;
        this.portalSettings = portalSettings;
    }

    @EventListener
    public void onAppInfoChange(AppInfoChangedEvent event) {
        AppDTO appDTO = (AppDTO)BeanUtils.transform(AppDTO.class, (Object)event.getApp());
        String appId = appDTO.getAppId();
        List<Env> envs = this.portalSettings.getActiveEnvs();
        for (Env env : envs) {
            try {
                this.appAPI.updateApp(env, appDTO);
            }
            catch (Throwable e) {
                logger.error("Update app's info failed. Env = {}, AppId = {}", new Object[]{env, appId, e});
                Tracer.logError((String)String.format("Update app's info failed. Env = %s, AppId = %s", env, appId), (Throwable)e);
            }
        }
    }
}

