/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.environment;

import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.core.utils.NetUtil;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.environment.DatabasePortalMetaServerProvider;
import com.ctrip.framework.apollo.portal.environment.DefaultPortalMetaServerProvider;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.environment.PortalMetaServerProvider;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PortalMetaDomainService {
    private static final Logger logger = LoggerFactory.getLogger(PortalMetaDomainService.class);
    private static final long REFRESH_INTERVAL_IN_SECOND = 60L;
    static final String DEFAULT_META_URL = "http://apollo.meta";
    private final Map<Env, String> metaServerAddressCache = Maps.newConcurrentMap();
    private final List<PortalMetaServerProvider> portalMetaServerProviders = new ArrayList<PortalMetaServerProvider>();
    private final Map<String, String> selectedMetaServerAddressCache = Maps.newConcurrentMap();
    private final AtomicBoolean periodicRefreshStarted = new AtomicBoolean(false);

    PortalMetaDomainService(PortalConfig portalConfig) {
        this.portalMetaServerProviders.add(new DatabasePortalMetaServerProvider(portalConfig));
        this.portalMetaServerProviders.add(new DefaultPortalMetaServerProvider());
    }

    public String getDomain(Env env) {
        String metaServerAddress = this.getMetaServerAddress(env);
        if (metaServerAddress.contains(",")) {
            return this.selectMetaServerAddress(metaServerAddress);
        }
        return metaServerAddress;
    }

    public String getMetaServerAddress(Env env) {
        if (!this.metaServerAddressCache.containsKey(env)) {
            this.metaServerAddressCache.put(env, this.getMetaServerAddressCacheValue(this.portalMetaServerProviders, env));
        }
        return this.metaServerAddressCache.get(env);
    }

    private String getMetaServerAddressCacheValue(Collection<PortalMetaServerProvider> providers, Env env) {
        String metaAddress = null;
        for (PortalMetaServerProvider portalMetaServerProvider : providers) {
            if (!portalMetaServerProvider.exists(env)) continue;
            metaAddress = portalMetaServerProvider.getMetaServerAddress(env);
            logger.info("Located meta server address [{}] for env [{}]", (Object)metaAddress, (Object)env);
            break;
        }
        if (Strings.isNullOrEmpty(metaAddress)) {
            metaAddress = DEFAULT_META_URL;
            logger.warn("Meta server address fallback to [{}] for env [{}], because it is not available in MetaServerProvider", (Object)metaAddress, (Object)env);
        }
        return metaAddress.trim();
    }

    public void reload() {
        for (PortalMetaServerProvider portalMetaServerProvider : this.portalMetaServerProviders) {
            portalMetaServerProvider.reload();
        }
        this.metaServerAddressCache.clear();
    }

    private String selectMetaServerAddress(String metaServerAddresses) {
        String metaAddressSelected = this.selectedMetaServerAddressCache.get(metaServerAddresses);
        if (metaAddressSelected == null) {
            if (this.periodicRefreshStarted.compareAndSet(false, true)) {
                this.schedulePeriodicRefresh();
            }
            this.updateMetaServerAddresses(metaServerAddresses);
            metaAddressSelected = this.selectedMetaServerAddressCache.get(metaServerAddresses);
        }
        return metaAddressSelected;
    }

    private void updateMetaServerAddresses(String metaServerAddresses) {
        logger.debug("Selecting meta server address for: {}", (Object)metaServerAddresses);
        Transaction transaction = Tracer.newTransaction((String)"Apollo.MetaService", (String)"refreshMetaServerAddress");
        transaction.addData("Url", (Object)metaServerAddresses);
        try {
            ArrayList metaServers = Lists.newArrayList((Object[])metaServerAddresses.split(","));
            Collections.shuffle(metaServers);
            boolean serverAvailable = false;
            for (String address : metaServers) {
                if (!NetUtil.pingUrl((String)((address = address.trim()) + "/services/config"))) continue;
                this.selectedMetaServerAddressCache.put(metaServerAddresses, address);
                serverAvailable = true;
                logger.debug("Selected meta server address {} for {}", (Object)address, (Object)metaServerAddresses);
                break;
            }
            if (!this.selectedMetaServerAddressCache.containsKey(metaServerAddresses)) {
                this.selectedMetaServerAddressCache.put(metaServerAddresses, ((String)metaServers.get(0)).trim());
            }
            if (!serverAvailable) {
                logger.warn("Could not find available meta server for configured meta server addresses: {}, fallback to: {}", (Object)metaServerAddresses, (Object)this.selectedMetaServerAddressCache.get(metaServerAddresses));
            }
            transaction.setStatus("0");
        }
        catch (Throwable ex) {
            transaction.setStatus(ex);
            throw ex;
        }
        finally {
            transaction.complete();
        }
    }

    private void schedulePeriodicRefresh() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, ApolloThreadFactory.create((String)"MetaServiceLocator", (boolean)true));
        scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String metaServerAddresses : PortalMetaDomainService.this.selectedMetaServerAddressCache.keySet()) {
                        PortalMetaDomainService.this.updateMetaServerAddresses(metaServerAddresses);
                    }
                }
                catch (Throwable ex) {
                    logger.warn(String.format("Refreshing meta server address failed, will retry in %d seconds", 60L), ex);
                }
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }
}

