/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.environment;

import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Env {
    private static final Logger logger = LoggerFactory.getLogger(Env.class);
    private final String name;
    private static final Map<String, Env> STRING_ENV_MAP = new ConcurrentHashMap<String, Env>();
    public static final Env LOCAL = Env.addEnvironment("LOCAL");
    public static final Env DEV = Env.addEnvironment("DEV");
    public static final Env FWS = Env.addEnvironment("FWS");
    public static final Env FAT = Env.addEnvironment("FAT");
    public static final Env UAT = Env.addEnvironment("UAT");
    public static final Env LPT = Env.addEnvironment("LPT");
    public static final Env PRO = Env.addEnvironment("PRO");
    public static final Env TOOLS = Env.addEnvironment("TOOLS");
    public static final Env UNKNOWN = Env.addEnvironment("UNKNOWN");

    private Env(String name) {
        this.name = name;
    }

    private static String getWellFormName(String environmentName) {
        return environmentName.trim().toUpperCase();
    }

    public static Env transformEnv(String envName) {
        if (Env.exists(envName)) {
            return Env.valueOf(envName);
        }
        if (StringUtils.isBlank((String)envName)) {
            return UNKNOWN;
        }
        switch (envName.trim().toUpperCase()) {
            case "LPT": {
                return LPT;
            }
            case "FAT": 
            case "FWS": {
                return FAT;
            }
            case "UAT": {
                return UAT;
            }
            case "PRO": 
            case "PROD": {
                return PRO;
            }
            case "DEV": {
                return DEV;
            }
            case "LOCAL": {
                return LOCAL;
            }
            case "TOOLS": {
                return TOOLS;
            }
        }
        return UNKNOWN;
    }

    public static boolean exists(String name) {
        name = Env.getWellFormName(name);
        return STRING_ENV_MAP.containsKey(name);
    }

    public static Env addEnvironment(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new RuntimeException("Cannot add a blank environment: [" + name + "]");
        }
        if (STRING_ENV_MAP.containsKey(name = Env.getWellFormName(name))) {
            logger.debug("{} already exists.", (Object)name);
        } else {
            STRING_ENV_MAP.put(name, new Env(name));
        }
        return STRING_ENV_MAP.get(name);
    }

    public static Env valueOf(String name) {
        if (Env.exists(name = Env.getWellFormName(name))) {
            return STRING_ENV_MAP.get(name);
        }
        throw new IllegalArgumentException(name + " not exist");
    }

    @Deprecated
    public static Env fromString(String env) {
        Env environment = Env.transformEnv(env);
        Preconditions.checkArgument((environment != UNKNOWN ? 1 : 0) != 0, (Object)String.format("Env %s is invalid", env));
        return environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Env env = (Env)o;
        if (this.getName().equals(env.getName())) {
            throw new RuntimeException(this.getName() + " is same environment name, but their Env not same");
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public String toString() {
        return this.name;
    }

    @Deprecated
    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    static Map<Env, String> transformToEnvMap(Map<String, String> metaServerAddresses) {
        ConcurrentHashMap<Env, String> map = new ConcurrentHashMap<Env, String>();
        for (Map.Entry<String, String> entry : metaServerAddresses.entrySet()) {
            Env env = Env.addEnvironment(entry.getKey());
            String value = entry.getValue();
            map.put(env, value);
        }
        return map;
    }
}

