/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.environment;

import com.ctrip.framework.apollo.core.utils.ResourceUtils;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.environment.PortalMetaServerProvider;
import com.ctrip.framework.apollo.portal.util.KeyValueUtils;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultPortalMetaServerProvider
implements PortalMetaServerProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPortalMetaServerProvider.class);
    private static final String APOLLO_ENV_PROPERTIES_FILE_PATH = "apollo-env.properties";
    private volatile Map<Env, String> domains;

    DefaultPortalMetaServerProvider() {
        this.reload();
    }

    @Override
    public String getMetaServerAddress(Env targetEnv) {
        String metaServerAddress = this.domains.get(targetEnv);
        return metaServerAddress == null ? null : metaServerAddress.trim();
    }

    @Override
    public boolean exists(Env targetEnv) {
        return this.domains.containsKey(targetEnv);
    }

    @Override
    public void reload() {
        this.domains = this.initializeDomains();
        logger.info("Loaded meta server addresses from system property, os environment and properties file: {}", this.domains);
    }

    private Map<Env, String> initializeDomains() {
        ConcurrentHashMap<Env, String> map = new ConcurrentHashMap<Env, String>();
        map.putAll(this.getDomainsFromPropertiesFile());
        map.putAll(this.getDomainsFromOSEnvironment());
        map.putAll(this.getDomainsFromSystemProperty());
        return map;
    }

    private Map<Env, String> getDomainsFromSystemProperty() {
        Map<String, String> metaServerAddressesFromSystemProperty = KeyValueUtils.filterWithKeyIgnoreCaseEndsWith(System.getProperties(), "_meta");
        metaServerAddressesFromSystemProperty = KeyValueUtils.removeKeySuffix(metaServerAddressesFromSystemProperty, "_meta".length());
        return Env.transformToEnvMap(metaServerAddressesFromSystemProperty);
    }

    private Map<Env, String> getDomainsFromOSEnvironment() {
        Map<String, String> metaServerAddressesFromOSEnvironment = KeyValueUtils.filterWithKeyIgnoreCaseEndsWith(System.getenv(), "_meta");
        metaServerAddressesFromOSEnvironment = KeyValueUtils.removeKeySuffix(metaServerAddressesFromOSEnvironment, "_meta".length());
        return Env.transformToEnvMap(metaServerAddressesFromOSEnvironment);
    }

    private Map<Env, String> getDomainsFromPropertiesFile() {
        Properties properties = new Properties();
        properties = ResourceUtils.readConfigFile((String)APOLLO_ENV_PROPERTIES_FILE_PATH, (Properties)properties);
        Map<String, String> metaServerAddressesFromPropertiesFile = KeyValueUtils.filterWithKeyIgnoreCaseEndsWith(properties, ".meta");
        metaServerAddressesFromPropertiesFile = KeyValueUtils.removeKeySuffix(metaServerAddressesFromPropertiesFile, ".meta".length());
        return Env.transformToEnvMap(metaServerAddressesFromPropertiesFile);
    }
}

