/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.environment;

import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.environment.PortalMetaServerProvider;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabasePortalMetaServerProvider
implements PortalMetaServerProvider {
    private static final Logger logger = LoggerFactory.getLogger(DatabasePortalMetaServerProvider.class);
    private final PortalConfig portalConfig;
    private volatile Map<Env, String> addresses;

    DatabasePortalMetaServerProvider(PortalConfig portalConfig) {
        this.portalConfig = portalConfig;
        this.reload();
    }

    @Override
    public String getMetaServerAddress(Env targetEnv) {
        return this.addresses.get(targetEnv);
    }

    @Override
    public boolean exists(Env targetEnv) {
        return this.addresses.containsKey(targetEnv);
    }

    @Override
    public void reload() {
        Map<String, String> map = this.portalConfig.getMetaServers();
        this.addresses = Env.transformToEnvMap(map);
        logger.info("Loaded meta server addresses from portal config: {}", this.addresses);
    }
}

