/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.entity.bo;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.portal.entity.bo.NamespaceBO;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.util.NamespaceBOUtils;

public class ConfigBO {
    private final Env env;
    private final String ownerName;
    private final String appId;
    private final String clusterName;
    private final String namespace;
    private final String configFileContent;
    private final ConfigFileFormat format;

    public ConfigBO(Env env, String ownerName, String appId, String clusterName, String namespace, String configFileContent, ConfigFileFormat format) {
        this.env = env;
        this.ownerName = ownerName;
        this.appId = appId;
        this.clusterName = clusterName;
        this.namespace = namespace;
        this.configFileContent = configFileContent;
        this.format = format;
    }

    public ConfigBO(Env env, String ownerName, String appId, String clusterName, NamespaceBO namespaceBO) {
        this(env, ownerName, appId, clusterName, namespaceBO.getBaseInfo().getNamespaceName(), NamespaceBOUtils.convert2configFileContent(namespaceBO), ConfigFileFormat.fromString((String)namespaceBO.getFormat()));
    }

    public String toString() {
        return "ConfigBO{env=" + this.env + ", ownerName='" + this.ownerName + '\'' + ", appId='" + this.appId + '\'' + ", clusterName='" + this.clusterName + '\'' + ", namespace='" + this.namespace + '\'' + ", configFileContent='" + this.configFileContent + '\'' + ", format=" + this.format + '}';
    }

    public Env getEnv() {
        return this.env;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getConfigFileContent() {
        return this.configFileContent;
    }

    public ConfigFileFormat getFormat() {
        return this.format;
    }
}

