/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.controller;

import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.portal.entity.bo.UserInfo;
import com.ctrip.framework.apollo.portal.entity.po.UserPO;
import com.ctrip.framework.apollo.portal.spi.LogoutHandler;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.portal.spi.UserService;
import com.ctrip.framework.apollo.portal.spi.springsecurity.SpringSecurityUserService;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserInfoController {
    private final UserInfoHolder userInfoHolder;
    private final LogoutHandler logoutHandler;
    private final UserService userService;

    public UserInfoController(UserInfoHolder userInfoHolder, LogoutHandler logoutHandler, UserService userService) {
        this.userInfoHolder = userInfoHolder;
        this.logoutHandler = logoutHandler;
        this.userService = userService;
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @PostMapping(value={"/users"})
    public void createOrUpdateUser(@RequestBody UserPO user) {
        if (StringUtils.isContainEmpty((String[])new String[]{user.getUsername(), user.getPassword()})) {
            throw new BadRequestException("Username and password can not be empty.");
        }
        if (!(this.userService instanceof SpringSecurityUserService)) {
            throw new UnsupportedOperationException("Create or update user operation is unsupported");
        }
        ((SpringSecurityUserService)this.userService).createOrUpdate(user);
    }

    @GetMapping(value={"/user"})
    public UserInfo getCurrentUserName() {
        return this.userInfoHolder.getUser();
    }

    @GetMapping(value={"/user/logout"})
    public void logout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logoutHandler.logout(request, response);
    }

    @GetMapping(value={"/users"})
    public List<UserInfo> searchUsersByKeyword(@RequestParam(value="keyword") String keyword, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="10") int limit) {
        return this.userService.searchUsers(keyword, offset, limit);
    }

    @GetMapping(value={"/users/{userId}"})
    public UserInfo getUserByUserId(@PathVariable String userId) {
        return this.userService.findByUserId(userId);
    }
}

