/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.controller;

import com.ctrip.framework.apollo.Apollo;
import com.ctrip.framework.apollo.core.dto.ServiceDTO;
import com.ctrip.framework.apollo.portal.component.PortalSettings;
import com.ctrip.framework.apollo.portal.component.RestTemplateFactory;
import com.ctrip.framework.apollo.portal.entity.vo.EnvironmentInfo;
import com.ctrip.framework.apollo.portal.entity.vo.SystemInfo;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.environment.PortalMetaDomainService;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/system-info"})
public class SystemInfoController {
    private static final Logger logger = LoggerFactory.getLogger(SystemInfoController.class);
    private static final String CONFIG_SERVICE_URL_PATH = "/services/config";
    private static final String ADMIN_SERVICE_URL_PATH = "/services/admin";
    private RestTemplate restTemplate;
    private final PortalSettings portalSettings;
    private final RestTemplateFactory restTemplateFactory;
    private final PortalMetaDomainService portalMetaDomainService;

    public SystemInfoController(PortalSettings portalSettings, RestTemplateFactory restTemplateFactory, PortalMetaDomainService portalMetaDomainService) {
        this.portalSettings = portalSettings;
        this.restTemplateFactory = restTemplateFactory;
        this.portalMetaDomainService = portalMetaDomainService;
    }

    @PostConstruct
    private void init() {
        this.restTemplate = this.restTemplateFactory.getObject();
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @GetMapping
    public SystemInfo getSystemInfo() {
        SystemInfo systemInfo = new SystemInfo();
        String version = Apollo.VERSION;
        if (this.isValidVersion(version)) {
            systemInfo.setVersion(version);
        }
        List<Env> allEnvList = this.portalSettings.getAllEnvs();
        for (Env env : allEnvList) {
            EnvironmentInfo environmentInfo = this.adaptEnv2EnvironmentInfo(env);
            systemInfo.addEnvironment(environmentInfo);
        }
        return systemInfo;
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @GetMapping(value={"/health"})
    public Health checkHealth(@RequestParam String instanceId) {
        List<Env> allEnvs = this.portalSettings.getAllEnvs();
        ServiceDTO service = null;
        block0: for (Env env : allEnvs) {
            EnvironmentInfo envInfo = this.adaptEnv2EnvironmentInfo(env);
            if (envInfo.getAdminServices() != null) {
                for (ServiceDTO s : envInfo.getAdminServices()) {
                    if (!instanceId.equals(s.getInstanceId())) continue;
                    service = s;
                    break;
                }
            }
            if (envInfo.getConfigServices() == null) continue;
            for (ServiceDTO s : envInfo.getConfigServices()) {
                if (!instanceId.equals(s.getInstanceId())) continue;
                service = s;
                continue block0;
            }
        }
        if (service == null) {
            throw new IllegalArgumentException("No such instance of instanceId: " + instanceId);
        }
        return (Health)this.restTemplate.getForObject(service.getHomepageUrl() + "/health", Health.class, new Object[0]);
    }

    private EnvironmentInfo adaptEnv2EnvironmentInfo(Env env) {
        EnvironmentInfo environmentInfo = new EnvironmentInfo();
        String metaServerAddresses = this.portalMetaDomainService.getMetaServerAddress(env);
        environmentInfo.setEnv(env);
        environmentInfo.setActive(this.portalSettings.isEnvActive(env));
        environmentInfo.setMetaServerAddress(metaServerAddresses);
        String selectedMetaServerAddress = this.portalMetaDomainService.getDomain(env);
        try {
            environmentInfo.setConfigServices(this.getServerAddress(selectedMetaServerAddress, CONFIG_SERVICE_URL_PATH));
            environmentInfo.setAdminServices(this.getServerAddress(selectedMetaServerAddress, ADMIN_SERVICE_URL_PATH));
        }
        catch (Throwable ex) {
            String errorMessage = "Loading config/admin services from meta server: " + selectedMetaServerAddress + " failed!";
            logger.error(errorMessage, ex);
            environmentInfo.setErrorMessage(errorMessage + " Exception: " + ex.getMessage());
        }
        return environmentInfo;
    }

    private ServiceDTO[] getServerAddress(String metaServerAddress, String path) {
        String url = metaServerAddress + path;
        return (ServiceDTO[])this.restTemplate.getForObject(url, ServiceDTO[].class, new Object[0]);
    }

    private boolean isValidVersion(String version) {
        return !version.equals("java-null");
    }
}

