/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.controller;

import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.portal.entity.po.ServerConfig;
import com.ctrip.framework.apollo.portal.repository.ServerConfigRepository;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServerConfigController {
    private final ServerConfigRepository serverConfigRepository;
    private final UserInfoHolder userInfoHolder;

    public ServerConfigController(ServerConfigRepository serverConfigRepository, UserInfoHolder userInfoHolder) {
        this.serverConfigRepository = serverConfigRepository;
        this.userInfoHolder = userInfoHolder;
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @PostMapping(value={"/server/config"})
    public ServerConfig createOrUpdate(@Valid @RequestBody ServerConfig serverConfig) {
        String modifiedBy = this.userInfoHolder.getUser().getUserId();
        ServerConfig storedConfig = this.serverConfigRepository.findByKey(serverConfig.getKey());
        if (Objects.isNull((Object)storedConfig)) {
            serverConfig.setDataChangeCreatedBy(modifiedBy);
            serverConfig.setDataChangeLastModifiedBy(modifiedBy);
            serverConfig.setId(0L);
            return (ServerConfig)((Object)this.serverConfigRepository.save((Object)serverConfig));
        }
        BeanUtils.copyEntityProperties((Object)((Object)serverConfig), (Object)((Object)storedConfig));
        storedConfig.setDataChangeLastModifiedBy(modifiedBy);
        return (ServerConfig)((Object)this.serverConfigRepository.save((Object)storedConfig));
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @GetMapping(value={"/server/config/{key:.+}"})
    public ServerConfig loadServerConfig(@PathVariable String key) {
        return this.serverConfigRepository.findByKey(key);
    }
}

