/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.controller;

import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.common.utils.RequestPrecondition;
import com.ctrip.framework.apollo.portal.component.PermissionValidator;
import com.ctrip.framework.apollo.portal.constant.RoleType;
import com.ctrip.framework.apollo.portal.entity.bo.UserInfo;
import com.ctrip.framework.apollo.portal.entity.vo.AppRolesAssignedUsers;
import com.ctrip.framework.apollo.portal.entity.vo.NamespaceEnvRolesAssignedUsers;
import com.ctrip.framework.apollo.portal.entity.vo.NamespaceRolesAssignedUsers;
import com.ctrip.framework.apollo.portal.entity.vo.PermissionCondition;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.RoleInitializationService;
import com.ctrip.framework.apollo.portal.service.RolePermissionService;
import com.ctrip.framework.apollo.portal.service.SystemRoleManagerService;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.portal.spi.UserService;
import com.ctrip.framework.apollo.portal.util.RoleUtils;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PermissionController {
    private final UserInfoHolder userInfoHolder;
    private final RolePermissionService rolePermissionService;
    private final UserService userService;
    private final RoleInitializationService roleInitializationService;
    private final SystemRoleManagerService systemRoleManagerService;
    private final PermissionValidator permissionValidator;

    @Autowired
    public PermissionController(UserInfoHolder userInfoHolder, RolePermissionService rolePermissionService, UserService userService, RoleInitializationService roleInitializationService, SystemRoleManagerService systemRoleManagerService, PermissionValidator permissionValidator) {
        this.userInfoHolder = userInfoHolder;
        this.rolePermissionService = rolePermissionService;
        this.userService = userService;
        this.roleInitializationService = roleInitializationService;
        this.systemRoleManagerService = systemRoleManagerService;
        this.permissionValidator = permissionValidator;
    }

    @PostMapping(value={"/apps/{appId}/initPermission"})
    public ResponseEntity<Void> initAppPermission(@PathVariable String appId, @RequestBody String namespaceName) {
        this.roleInitializationService.initNamespaceEnvRoles(appId, namespaceName, this.userInfoHolder.getUser().getUserId());
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/apps/{appId}/permissions/{permissionType}"})
    public ResponseEntity<PermissionCondition> hasPermission(@PathVariable String appId, @PathVariable String permissionType) {
        PermissionCondition permissionCondition = new PermissionCondition();
        permissionCondition.setHasPermission(this.rolePermissionService.userHasPermission(this.userInfoHolder.getUser().getUserId(), permissionType, appId));
        return ResponseEntity.ok().body((Object)permissionCondition);
    }

    @GetMapping(value={"/apps/{appId}/namespaces/{namespaceName}/permissions/{permissionType}"})
    public ResponseEntity<PermissionCondition> hasPermission(@PathVariable String appId, @PathVariable String namespaceName, @PathVariable String permissionType) {
        PermissionCondition permissionCondition = new PermissionCondition();
        permissionCondition.setHasPermission(this.rolePermissionService.userHasPermission(this.userInfoHolder.getUser().getUserId(), permissionType, RoleUtils.buildNamespaceTargetId(appId, namespaceName)));
        return ResponseEntity.ok().body((Object)permissionCondition);
    }

    @GetMapping(value={"/apps/{appId}/envs/{env}/namespaces/{namespaceName}/permissions/{permissionType}"})
    public ResponseEntity<PermissionCondition> hasPermission(@PathVariable String appId, @PathVariable String env, @PathVariable String namespaceName, @PathVariable String permissionType) {
        PermissionCondition permissionCondition = new PermissionCondition();
        permissionCondition.setHasPermission(this.rolePermissionService.userHasPermission(this.userInfoHolder.getUser().getUserId(), permissionType, RoleUtils.buildNamespaceTargetId(appId, namespaceName, env)));
        return ResponseEntity.ok().body((Object)permissionCondition);
    }

    @GetMapping(value={"/permissions/root"})
    public ResponseEntity<PermissionCondition> hasRootPermission() {
        PermissionCondition permissionCondition = new PermissionCondition();
        permissionCondition.setHasPermission(this.rolePermissionService.isSuperAdmin(this.userInfoHolder.getUser().getUserId()));
        return ResponseEntity.ok().body((Object)permissionCondition);
    }

    @GetMapping(value={"/apps/{appId}/envs/{env}/namespaces/{namespaceName}/role_users"})
    public NamespaceEnvRolesAssignedUsers getNamespaceEnvRoles(@PathVariable String appId, @PathVariable String env, @PathVariable String namespaceName) {
        if (Env.UNKNOWN == Env.transformEnv(env)) {
            throw new BadRequestException("env is illegal");
        }
        NamespaceEnvRolesAssignedUsers assignedUsers = new NamespaceEnvRolesAssignedUsers();
        assignedUsers.setNamespaceName(namespaceName);
        assignedUsers.setAppId(appId);
        assignedUsers.setEnv(Env.fromString(env));
        Set<UserInfo> releaseNamespaceUsers = this.rolePermissionService.queryUsersWithRole(RoleUtils.buildReleaseNamespaceRoleName(appId, namespaceName, env));
        assignedUsers.setReleaseRoleUsers(releaseNamespaceUsers);
        Set<UserInfo> modifyNamespaceUsers = this.rolePermissionService.queryUsersWithRole(RoleUtils.buildModifyNamespaceRoleName(appId, namespaceName, env));
        assignedUsers.setModifyRoleUsers(modifyNamespaceUsers);
        return assignedUsers;
    }

    @PreAuthorize(value="@permissionValidator.hasAssignRolePermission(#appId)")
    @PostMapping(value={"/apps/{appId}/envs/{env}/namespaces/{namespaceName}/roles/{roleType}"})
    public ResponseEntity<Void> assignNamespaceEnvRoleToUser(@PathVariable String appId, @PathVariable String env, @PathVariable String namespaceName, @PathVariable String roleType, @RequestBody String user) {
        this.checkUserExists(user);
        RequestPrecondition.checkArgumentsNotEmpty((String[])new String[]{user});
        if (!RoleType.isValidRoleType(roleType)) {
            throw new BadRequestException("role type is illegal");
        }
        if (Env.UNKNOWN == Env.transformEnv(env)) {
            throw new BadRequestException("env is illegal");
        }
        Set<String> assignedUser = this.rolePermissionService.assignRoleToUsers(RoleUtils.buildNamespaceRoleName(appId, namespaceName, roleType, env), Sets.newHashSet((Object[])new String[]{user}), this.userInfoHolder.getUser().getUserId());
        if (CollectionUtils.isEmpty(assignedUser)) {
            throw new BadRequestException(user + " already authorized");
        }
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="@permissionValidator.hasAssignRolePermission(#appId)")
    @DeleteMapping(value={"/apps/{appId}/envs/{env}/namespaces/{namespaceName}/roles/{roleType}"})
    public ResponseEntity<Void> removeNamespaceEnvRoleFromUser(@PathVariable String appId, @PathVariable String env, @PathVariable String namespaceName, @PathVariable String roleType, @RequestParam String user) {
        RequestPrecondition.checkArgumentsNotEmpty((String[])new String[]{user});
        if (!RoleType.isValidRoleType(roleType)) {
            throw new BadRequestException("role type is illegal");
        }
        if (Env.UNKNOWN == Env.transformEnv(env)) {
            throw new BadRequestException("env is illegal");
        }
        this.rolePermissionService.removeRoleFromUsers(RoleUtils.buildNamespaceRoleName(appId, namespaceName, roleType, env), Sets.newHashSet((Object[])new String[]{user}), this.userInfoHolder.getUser().getUserId());
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/apps/{appId}/namespaces/{namespaceName}/role_users"})
    public NamespaceRolesAssignedUsers getNamespaceRoles(@PathVariable String appId, @PathVariable String namespaceName) {
        NamespaceRolesAssignedUsers assignedUsers = new NamespaceRolesAssignedUsers();
        assignedUsers.setNamespaceName(namespaceName);
        assignedUsers.setAppId(appId);
        Set<UserInfo> releaseNamespaceUsers = this.rolePermissionService.queryUsersWithRole(RoleUtils.buildReleaseNamespaceRoleName(appId, namespaceName));
        assignedUsers.setReleaseRoleUsers(releaseNamespaceUsers);
        Set<UserInfo> modifyNamespaceUsers = this.rolePermissionService.queryUsersWithRole(RoleUtils.buildModifyNamespaceRoleName(appId, namespaceName));
        assignedUsers.setModifyRoleUsers(modifyNamespaceUsers);
        return assignedUsers;
    }

    @PreAuthorize(value="@permissionValidator.hasAssignRolePermission(#appId)")
    @PostMapping(value={"/apps/{appId}/namespaces/{namespaceName}/roles/{roleType}"})
    public ResponseEntity<Void> assignNamespaceRoleToUser(@PathVariable String appId, @PathVariable String namespaceName, @PathVariable String roleType, @RequestBody String user) {
        this.checkUserExists(user);
        RequestPrecondition.checkArgumentsNotEmpty((String[])new String[]{user});
        if (!RoleType.isValidRoleType(roleType)) {
            throw new BadRequestException("role type is illegal");
        }
        Set<String> assignedUser = this.rolePermissionService.assignRoleToUsers(RoleUtils.buildNamespaceRoleName(appId, namespaceName, roleType), Sets.newHashSet((Object[])new String[]{user}), this.userInfoHolder.getUser().getUserId());
        if (CollectionUtils.isEmpty(assignedUser)) {
            throw new BadRequestException(user + " already authorized");
        }
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="@permissionValidator.hasAssignRolePermission(#appId)")
    @DeleteMapping(value={"/apps/{appId}/namespaces/{namespaceName}/roles/{roleType}"})
    public ResponseEntity<Void> removeNamespaceRoleFromUser(@PathVariable String appId, @PathVariable String namespaceName, @PathVariable String roleType, @RequestParam String user) {
        RequestPrecondition.checkArgumentsNotEmpty((String[])new String[]{user});
        if (!RoleType.isValidRoleType(roleType)) {
            throw new BadRequestException("role type is illegal");
        }
        this.rolePermissionService.removeRoleFromUsers(RoleUtils.buildNamespaceRoleName(appId, namespaceName, roleType), Sets.newHashSet((Object[])new String[]{user}), this.userInfoHolder.getUser().getUserId());
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/apps/{appId}/role_users"})
    public AppRolesAssignedUsers getAppRoles(@PathVariable String appId) {
        AppRolesAssignedUsers users = new AppRolesAssignedUsers();
        users.setAppId(appId);
        Set<UserInfo> masterUsers = this.rolePermissionService.queryUsersWithRole(RoleUtils.buildAppMasterRoleName(appId));
        users.setMasterUsers(masterUsers);
        return users;
    }

    @PreAuthorize(value="@permissionValidator.hasManageAppMasterPermission(#appId)")
    @PostMapping(value={"/apps/{appId}/roles/{roleType}"})
    public ResponseEntity<Void> assignAppRoleToUser(@PathVariable String appId, @PathVariable String roleType, @RequestBody String user) {
        this.checkUserExists(user);
        RequestPrecondition.checkArgumentsNotEmpty((String[])new String[]{user});
        if (!RoleType.isValidRoleType(roleType)) {
            throw new BadRequestException("role type is illegal");
        }
        Set<String> assignedUsers = this.rolePermissionService.assignRoleToUsers(RoleUtils.buildAppRoleName(appId, roleType), Sets.newHashSet((Object[])new String[]{user}), this.userInfoHolder.getUser().getUserId());
        if (CollectionUtils.isEmpty(assignedUsers)) {
            throw new BadRequestException(user + " already authorized");
        }
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="@permissionValidator.hasManageAppMasterPermission(#appId)")
    @DeleteMapping(value={"/apps/{appId}/roles/{roleType}"})
    public ResponseEntity<Void> removeAppRoleFromUser(@PathVariable String appId, @PathVariable String roleType, @RequestParam String user) {
        RequestPrecondition.checkArgumentsNotEmpty((String[])new String[]{user});
        if (!RoleType.isValidRoleType(roleType)) {
            throw new BadRequestException("role type is illegal");
        }
        this.rolePermissionService.removeRoleFromUsers(RoleUtils.buildAppRoleName(appId, roleType), Sets.newHashSet((Object[])new String[]{user}), this.userInfoHolder.getUser().getUserId());
        return ResponseEntity.ok().build();
    }

    private void checkUserExists(String userId) {
        if (this.userService.findByUserId(userId) == null) {
            throw new BadRequestException(String.format("User %s does not exist!", userId));
        }
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @PostMapping(value={"/system/role/createApplication"})
    public ResponseEntity<Void> addCreateApplicationRoleToUser(@RequestBody List<String> userIds) {
        userIds.forEach(this::checkUserExists);
        this.rolePermissionService.assignRoleToUsers(SystemRoleManagerService.CREATE_APPLICATION_ROLE_NAME, new HashSet<String>(userIds), this.userInfoHolder.getUser().getUserId());
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @DeleteMapping(value={"/system/role/createApplication/{userId}"})
    public ResponseEntity<Void> deleteCreateApplicationRoleFromUser(@PathVariable(value="userId") String userId) {
        this.checkUserExists(userId);
        HashSet<String> userIds = new HashSet<String>();
        userIds.add(userId);
        this.rolePermissionService.removeRoleFromUsers(SystemRoleManagerService.CREATE_APPLICATION_ROLE_NAME, userIds, this.userInfoHolder.getUser().getUserId());
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @GetMapping(value={"/system/role/createApplication"})
    public List<String> getCreateApplicationRoleUsers() {
        return this.rolePermissionService.queryUsersWithRole(SystemRoleManagerService.CREATE_APPLICATION_ROLE_NAME).stream().map(UserInfo::getUserId).collect(Collectors.toList());
    }

    @GetMapping(value={"/system/role/createApplication/{userId}"})
    public JsonObject hasCreateApplicationPermission(@PathVariable String userId) {
        JsonObject rs = new JsonObject();
        rs.addProperty("hasCreateApplicationPermission", Boolean.valueOf(this.permissionValidator.hasCreateApplicationPermission(userId)));
        return rs;
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @PostMapping(value={"/apps/{appId}/system/master/{userId}"})
    public ResponseEntity<Void> addManageAppMasterRoleToUser(@PathVariable String appId, @PathVariable String userId) {
        this.checkUserExists(userId);
        this.roleInitializationService.initManageAppMasterRole(appId, this.userInfoHolder.getUser().getUserId());
        HashSet<String> userIds = new HashSet<String>();
        userIds.add(userId);
        this.rolePermissionService.assignRoleToUsers(RoleUtils.buildAppRoleName(appId, "ManageAppMaster"), userIds, this.userInfoHolder.getUser().getUserId());
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @DeleteMapping(value={"/apps/{appId}/system/master/{userId}"})
    public ResponseEntity<Void> forbidManageAppMaster(@PathVariable String appId, @PathVariable String userId) {
        this.checkUserExists(userId);
        this.roleInitializationService.initManageAppMasterRole(appId, this.userInfoHolder.getUser().getUserId());
        HashSet<String> userIds = new HashSet<String>();
        userIds.add(userId);
        this.rolePermissionService.removeRoleFromUsers(RoleUtils.buildAppRoleName(appId, "ManageAppMaster"), userIds, this.userInfoHolder.getUser().getUserId());
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/system/role/manageAppMaster"})
    public JsonObject isManageAppMasterPermissionEnabled() {
        JsonObject rs = new JsonObject();
        rs.addProperty("isManageAppMasterPermissionEnabled", Boolean.valueOf(this.systemRoleManagerService.isManageAppMasterPermissionEnabled()));
        return rs;
    }
}

