/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.controller;

import com.ctrip.framework.apollo.common.dto.AppNamespaceDTO;
import com.ctrip.framework.apollo.common.dto.NamespaceDTO;
import com.ctrip.framework.apollo.common.entity.AppNamespace;
import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.common.http.MultiResponseEntity;
import com.ctrip.framework.apollo.common.http.RichResponseEntity;
import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.common.utils.InputValidator;
import com.ctrip.framework.apollo.common.utils.RequestPrecondition;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.component.PermissionValidator;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.entity.bo.NamespaceBO;
import com.ctrip.framework.apollo.portal.entity.model.NamespaceCreationModel;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.listener.AppNamespaceCreationEvent;
import com.ctrip.framework.apollo.portal.listener.AppNamespaceDeletionEvent;
import com.ctrip.framework.apollo.portal.service.AppNamespaceService;
import com.ctrip.framework.apollo.portal.service.NamespaceService;
import com.ctrip.framework.apollo.portal.service.RoleInitializationService;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NamespaceController {
    private static final Logger logger = LoggerFactory.getLogger(NamespaceController.class);
    private final ApplicationEventPublisher publisher;
    private final UserInfoHolder userInfoHolder;
    private final NamespaceService namespaceService;
    private final AppNamespaceService appNamespaceService;
    private final RoleInitializationService roleInitializationService;
    private final PortalConfig portalConfig;
    private final PermissionValidator permissionValidator;
    private final AdminServiceAPI.NamespaceAPI namespaceAPI;

    public NamespaceController(ApplicationEventPublisher publisher, UserInfoHolder userInfoHolder, NamespaceService namespaceService, AppNamespaceService appNamespaceService, RoleInitializationService roleInitializationService, PortalConfig portalConfig, PermissionValidator permissionValidator, AdminServiceAPI.NamespaceAPI namespaceAPI) {
        this.publisher = publisher;
        this.userInfoHolder = userInfoHolder;
        this.namespaceService = namespaceService;
        this.appNamespaceService = appNamespaceService;
        this.roleInitializationService = roleInitializationService;
        this.portalConfig = portalConfig;
        this.permissionValidator = permissionValidator;
        this.namespaceAPI = namespaceAPI;
    }

    @GetMapping(value={"/appnamespaces/public"})
    public List<AppNamespace> findPublicAppNamespaces() {
        return this.appNamespaceService.findPublicAppNamespaces();
    }

    @GetMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces"})
    public List<NamespaceBO> findNamespaces(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName) {
        List<NamespaceBO> namespaceBOs = this.namespaceService.findNamespaceBOs(appId, Env.valueOf(env), clusterName);
        for (NamespaceBO namespaceBO : namespaceBOs) {
            if (!this.permissionValidator.shouldHideConfigToCurrentUser(appId, env, namespaceBO.getBaseInfo().getNamespaceName())) continue;
            namespaceBO.hideItems();
        }
        return namespaceBOs;
    }

    @GetMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName:.+}"})
    public NamespaceBO findNamespace(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName) {
        NamespaceBO namespaceBO = this.namespaceService.loadNamespaceBO(appId, Env.valueOf(env), clusterName, namespaceName);
        if (namespaceBO != null && this.permissionValidator.shouldHideConfigToCurrentUser(appId, env, namespaceName)) {
            namespaceBO.hideItems();
        }
        return namespaceBO;
    }

    @GetMapping(value={"/envs/{env}/apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/associated-public-namespace"})
    public NamespaceBO findPublicNamespaceForAssociatedNamespace(@PathVariable String env, @PathVariable String appId, @PathVariable String namespaceName, @PathVariable String clusterName) {
        return this.namespaceService.findPublicNamespaceForAssociatedNamespace(Env.valueOf(env), appId, clusterName, namespaceName);
    }

    @PreAuthorize(value="@permissionValidator.hasCreateNamespacePermission(#appId)")
    @PostMapping(value={"/apps/{appId}/namespaces"})
    public ResponseEntity<Void> createNamespace(@PathVariable String appId, @RequestBody List<NamespaceCreationModel> models) {
        RequestPrecondition.checkModel((!CollectionUtils.isEmpty(models) ? 1 : 0) != 0);
        String namespaceName = models.get(0).getNamespace().getNamespaceName();
        String operator = this.userInfoHolder.getUser().getUserId();
        this.roleInitializationService.initNamespaceRoles(appId, namespaceName, operator);
        this.roleInitializationService.initNamespaceEnvRoles(appId, namespaceName, operator);
        for (NamespaceCreationModel model : models) {
            NamespaceDTO namespace = model.getNamespace();
            RequestPrecondition.checkArgumentsNotEmpty((String[])new String[]{model.getEnv(), namespace.getAppId(), namespace.getClusterName(), namespace.getNamespaceName()});
            try {
                this.namespaceService.createNamespace(Env.valueOf(model.getEnv()), namespace);
            }
            catch (Exception e) {
                logger.error("create namespace fail.", (Throwable)e);
                Tracer.logError((String)String.format("create namespace fail. (env=%s namespace=%s)", model.getEnv(), namespace.getNamespaceName()), (Throwable)e);
            }
        }
        this.namespaceService.assignNamespaceRoleToOperator(appId, namespaceName, this.userInfoHolder.getUser().getUserId());
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="@permissionValidator.hasDeleteNamespacePermission(#appId)")
    @DeleteMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName:.+}"})
    public ResponseEntity<Void> deleteNamespace(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName) {
        this.namespaceService.deleteNamespace(appId, Env.valueOf(env), clusterName, namespaceName);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @DeleteMapping(value={"/apps/{appId}/appnamespaces/{namespaceName:.+}"})
    public ResponseEntity<Void> deleteAppNamespace(@PathVariable String appId, @PathVariable String namespaceName) {
        AppNamespace appNamespace = this.appNamespaceService.deleteAppNamespace(appId, namespaceName);
        this.publisher.publishEvent((ApplicationEvent)new AppNamespaceDeletionEvent(appNamespace));
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/apps/{appId}/appnamespaces/{namespaceName:.+}"})
    public AppNamespaceDTO findAppNamespace(@PathVariable String appId, @PathVariable String namespaceName) {
        AppNamespace appNamespace = this.appNamespaceService.findByAppIdAndName(appId, namespaceName);
        if (appNamespace == null) {
            throw new BadRequestException(String.format("AppNamespace not exists. AppId = %s, NamespaceName = %s", appId, namespaceName));
        }
        return (AppNamespaceDTO)BeanUtils.transform(AppNamespaceDTO.class, (Object)appNamespace);
    }

    @PreAuthorize(value="@permissionValidator.hasCreateAppNamespacePermission(#appId, #appNamespace)")
    @PostMapping(value={"/apps/{appId}/appnamespaces"})
    public AppNamespace createAppNamespace(@PathVariable String appId, @RequestParam(defaultValue="true") boolean appendNamespacePrefix, @Valid @RequestBody AppNamespace appNamespace) {
        if (!InputValidator.isValidAppNamespace((String)appNamespace.getName())) {
            throw new BadRequestException(String.format("Invalid Namespace format: %s", "Only digits, alphabets and symbol - _ . are allowed & not allowed to end with .json, .yml, .yaml, .xml, .properties"));
        }
        AppNamespace createdAppNamespace = this.appNamespaceService.createAppNamespaceInLocal(appNamespace, appendNamespacePrefix);
        if (this.portalConfig.canAppAdminCreatePrivateNamespace() || createdAppNamespace.isPublic()) {
            this.namespaceService.assignNamespaceRoleToOperator(appId, appNamespace.getName(), this.userInfoHolder.getUser().getUserId());
        }
        this.publisher.publishEvent((ApplicationEvent)new AppNamespaceCreationEvent(createdAppNamespace));
        return createdAppNamespace;
    }

    @GetMapping(value={"/apps/{appId}/namespaces/publish_info"})
    public Map<String, Map<String, Boolean>> getNamespacesPublishInfo(@PathVariable String appId) {
        return this.namespaceService.getNamespacesPublishInfo(appId);
    }

    @GetMapping(value={"/envs/{env}/appnamespaces/{publicNamespaceName}/namespaces"})
    public List<NamespaceDTO> getPublicAppNamespaceAllNamespaces(@PathVariable String env, @PathVariable String publicNamespaceName, @RequestParam(name="page", defaultValue="0") int page, @RequestParam(name="size", defaultValue="10") int size) {
        return this.namespaceService.getPublicAppNamespaceAllNamespaces(Env.fromString(env), publicNamespaceName, page, size);
    }

    @GetMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/missing-namespaces"})
    public MultiResponseEntity<String> findMissingNamespaces(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName) {
        MultiResponseEntity response = MultiResponseEntity.ok();
        Set<String> missingNamespaces = this.findMissingNamespaceNames(appId, env, clusterName);
        for (String missingNamespace : missingNamespaces) {
            response.addResponseEntity(RichResponseEntity.ok((Object)missingNamespace));
        }
        return response;
    }

    @PostMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/missing-namespaces"})
    public ResponseEntity<Void> createMissingNamespaces(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName) {
        Set<String> missingNamespaces = this.findMissingNamespaceNames(appId, env, clusterName);
        for (String missingNamespace : missingNamespaces) {
            this.namespaceAPI.createMissingAppNamespace(Env.fromString(env), this.findAppNamespace(appId, missingNamespace));
        }
        return ResponseEntity.ok().build();
    }

    private Set<String> findMissingNamespaceNames(String appId, String env, String clusterName) {
        List<AppNamespaceDTO> configDbAppNamespaces = this.namespaceAPI.getAppNamespaces(appId, Env.fromString(env));
        List<NamespaceDTO> configDbNamespaces = this.namespaceService.findNamespaces(appId, Env.fromString(env), clusterName);
        List<AppNamespace> portalDbAppNamespaces = this.appNamespaceService.findByAppId(appId);
        Set configDbAppNamespaceNames = configDbAppNamespaces.stream().map(AppNamespaceDTO::getName).collect(Collectors.toSet());
        Set configDbNamespaceNames = configDbNamespaces.stream().map(NamespaceDTO::getNamespaceName).collect(Collectors.toSet());
        HashSet portalDbAllAppNamespaceNames = Sets.newHashSet();
        HashSet portalDbPrivateAppNamespaceNames = Sets.newHashSet();
        for (AppNamespace appNamespace : portalDbAppNamespaces) {
            portalDbAllAppNamespaceNames.add(appNamespace.getName());
            if (appNamespace.isPublic()) continue;
            portalDbPrivateAppNamespaceNames.add(appNamespace.getName());
        }
        Sets.SetView missingAppNamespaceNames = Sets.difference((Set)portalDbAllAppNamespaceNames, configDbAppNamespaceNames);
        Sets.SetView missingNamespaceNames = Sets.difference((Set)portalDbPrivateAppNamespaceNames, configDbNamespaceNames);
        return Sets.union((Set)missingAppNamespaceNames, (Set)missingNamespaceNames);
    }
}

