/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.controller;

import com.ctrip.framework.apollo.common.dto.ItemChangeSets;
import com.ctrip.framework.apollo.common.dto.ItemDTO;
import com.ctrip.framework.apollo.common.dto.NamespaceDTO;
import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.common.utils.RequestPrecondition;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.portal.component.PermissionValidator;
import com.ctrip.framework.apollo.portal.entity.model.NamespaceSyncModel;
import com.ctrip.framework.apollo.portal.entity.model.NamespaceTextModel;
import com.ctrip.framework.apollo.portal.entity.vo.ItemDiffs;
import com.ctrip.framework.apollo.portal.entity.vo.NamespaceIdentifier;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.ItemService;
import com.ctrip.framework.apollo.portal.service.NamespaceService;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

@RestController
public class ItemController {
    private final ItemService configService;
    private final NamespaceService namespaceService;
    private final UserInfoHolder userInfoHolder;
    private final PermissionValidator permissionValidator;

    public ItemController(ItemService configService, UserInfoHolder userInfoHolder, PermissionValidator permissionValidator, NamespaceService namespaceService) {
        this.configService = configService;
        this.userInfoHolder = userInfoHolder;
        this.permissionValidator = permissionValidator;
        this.namespaceService = namespaceService;
    }

    @PreAuthorize(value="@permissionValidator.hasModifyNamespacePermission(#appId, #namespaceName, #env)")
    @PutMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName}/items"}, consumes={"application/json"})
    public void modifyItemsByText(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, @RequestBody NamespaceTextModel model) {
        model.setAppId(appId);
        model.setClusterName(clusterName);
        model.setEnv(env);
        model.setNamespaceName(namespaceName);
        this.configService.updateConfigItemByText(model);
    }

    @PreAuthorize(value="@permissionValidator.hasModifyNamespacePermission(#appId, #namespaceName, #env)")
    @PostMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName}/item"})
    public ItemDTO createItem(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, @RequestBody ItemDTO item) {
        RequestPrecondition.checkModel((boolean)this.isValidItem(item));
        item.setLineNum(0);
        item.setId(0L);
        String userId = this.userInfoHolder.getUser().getUserId();
        item.setDataChangeCreatedBy(userId);
        item.setDataChangeLastModifiedBy(userId);
        item.setDataChangeCreatedTime(null);
        item.setDataChangeLastModifiedTime(null);
        return this.configService.createItem(appId, Env.valueOf(env), clusterName, namespaceName, item);
    }

    @PreAuthorize(value="@permissionValidator.hasModifyNamespacePermission(#appId, #namespaceName, #env)")
    @PutMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName}/item"})
    public void updateItem(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, @RequestBody ItemDTO item) {
        RequestPrecondition.checkModel((boolean)this.isValidItem(item));
        String username = this.userInfoHolder.getUser().getUserId();
        item.setDataChangeLastModifiedBy(username);
        this.configService.updateItem(appId, Env.valueOf(env), clusterName, namespaceName, item);
    }

    @PreAuthorize(value="@permissionValidator.hasModifyNamespacePermission(#appId, #namespaceName, #env) ")
    @DeleteMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName}/items/{itemId}"})
    public void deleteItem(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, @PathVariable long itemId) {
        ItemDTO item = this.configService.loadItemById(Env.fromString(env), itemId);
        NamespaceDTO namespace = this.namespaceService.loadNamespaceBaseInfo(appId, Env.fromString(env), clusterName, namespaceName);
        if (item.getNamespaceId() != namespace.getId()) {
            throw new BadRequestException("Invalid request, item and namespace do not match!");
        }
        this.configService.deleteItem(Env.valueOf(env), itemId, this.userInfoHolder.getUser().getUserId());
    }

    @GetMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName}/items"})
    public List<ItemDTO> findItems(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, @RequestParam(defaultValue="lineNum") String orderBy) {
        if (this.permissionValidator.shouldHideConfigToCurrentUser(appId, env, namespaceName)) {
            return Collections.emptyList();
        }
        List<ItemDTO> items = this.configService.findItems(appId, Env.valueOf(env), clusterName, namespaceName);
        if ("lastModifiedTime".equals(orderBy)) {
            items.sort((o1, o2) -> {
                if (o1.getDataChangeLastModifiedTime().after(o2.getDataChangeLastModifiedTime())) {
                    return -1;
                }
                if (o1.getDataChangeLastModifiedTime().before(o2.getDataChangeLastModifiedTime())) {
                    return 1;
                }
                return 0;
            });
        }
        return items;
    }

    @GetMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName}/branches/{branchName}/items"})
    public List<ItemDTO> findBranchItems(@PathVariable(value="appId") String appId, @PathVariable String env, @PathVariable(value="clusterName") String clusterName, @PathVariable(value="namespaceName") String namespaceName, @PathVariable(value="branchName") String branchName) {
        return this.findItems(appId, env, branchName, namespaceName, "lastModifiedTime");
    }

    @PostMapping(value={"/namespaces/{namespaceName}/diff"}, consumes={"application/json"})
    public List<ItemDiffs> diff(@RequestBody NamespaceSyncModel model) {
        RequestPrecondition.checkModel((!model.isInvalid() ? 1 : 0) != 0);
        List<ItemDiffs> itemDiffs = this.configService.compare(model.getSyncToNamespaces(), model.getSyncItems());
        for (ItemDiffs diff : itemDiffs) {
            NamespaceIdentifier namespace = diff.getNamespace();
            if (namespace == null || !this.permissionValidator.shouldHideConfigToCurrentUser(namespace.getAppId(), namespace.getEnv().name(), namespace.getNamespaceName())) continue;
            diff.setDiffs(new ItemChangeSets());
            diff.setExtInfo("You are not this project's administrator, nor you have edit or release permission for the namespace in environment: " + namespace.getEnv());
        }
        return itemDiffs;
    }

    @PutMapping(value={"/apps/{appId}/namespaces/{namespaceName}/items"}, consumes={"application/json"})
    public ResponseEntity<Void> update(@PathVariable String appId, @PathVariable String namespaceName, @RequestBody NamespaceSyncModel model) {
        RequestPrecondition.checkModel((!model.isInvalid() ? 1 : 0) != 0);
        boolean hasPermission = this.permissionValidator.hasModifyNamespacePermission(appId, namespaceName);
        Env envNoPermission = null;
        if (!hasPermission) {
            hasPermission = true;
            for (NamespaceIdentifier namespaceIdentifier : model.getSyncToNamespaces()) {
                if (hasPermission &= this.permissionValidator.hasModifyNamespacePermission(namespaceIdentifier.getAppId(), namespaceIdentifier.getNamespaceName(), namespaceIdentifier.getEnv().toString())) continue;
                envNoPermission = namespaceIdentifier.getEnv();
                break;
            }
        }
        if (hasPermission) {
            this.configService.syncItems(model.getSyncToNamespaces(), model.getSyncItems());
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
        }
        throw new AccessDeniedException(String.format("You don't have the permission to modify environment: %s", envNoPermission));
    }

    @PreAuthorize(value="@permissionValidator.hasModifyNamespacePermission(#appId, #namespaceName, #env)")
    @PostMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName}/syntax-check"}, consumes={"application/json"})
    public ResponseEntity<Void> syntaxCheckText(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, @RequestBody NamespaceTextModel model) {
        this.doSyntaxCheck(model);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="@permissionValidator.hasModifyNamespacePermission(#appId, #namespaceName, #env)")
    @PutMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName}/revoke-items"})
    public void revokeItems(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName) {
        this.configService.revokeItem(appId, Env.valueOf(env), clusterName, namespaceName);
    }

    void doSyntaxCheck(NamespaceTextModel model) {
        if (StringUtils.isBlank((String)model.getConfigText())) {
            return;
        }
        if (model.getFormat() != ConfigFileFormat.YAML && model.getFormat() != ConfigFileFormat.YML) {
            return;
        }
        TypeLimitedYamlPropertiesFactoryBean yamlPropertiesFactoryBean = new TypeLimitedYamlPropertiesFactoryBean();
        yamlPropertiesFactoryBean.setResources(new Resource[]{new ByteArrayResource(model.getConfigText().getBytes())});
        yamlPropertiesFactoryBean.getObject();
    }

    private boolean isValidItem(ItemDTO item) {
        return Objects.nonNull(item) && !StringUtils.isContainEmpty((String[])new String[]{item.getKey()});
    }

    private static class TypeLimitedYamlPropertiesFactoryBean
    extends YamlPropertiesFactoryBean {
        private TypeLimitedYamlPropertiesFactoryBean() {
        }

        protected Yaml createYaml() {
            LoaderOptions loaderOptions = new LoaderOptions();
            loaderOptions.setAllowDuplicateKeys(false);
            return new Yaml((BaseConstructor)new SafeConstructor(), new Representer(), new DumperOptions(), loaderOptions);
        }
    }
}

