/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.controller;

import com.ctrip.framework.apollo.portal.entity.po.Favorite;
import com.ctrip.framework.apollo.portal.service.FavoriteService;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FavoriteController {
    private final FavoriteService favoriteService;

    public FavoriteController(FavoriteService favoriteService) {
        this.favoriteService = favoriteService;
    }

    @PostMapping(value={"/favorites"})
    public Favorite addFavorite(@RequestBody Favorite favorite) {
        return this.favoriteService.addFavorite(favorite);
    }

    @GetMapping(value={"/favorites"})
    public List<Favorite> findFavorites(@RequestParam(value="userId", required=false) String userId, @RequestParam(value="appId", required=false) String appId, Pageable page) {
        return this.favoriteService.search(userId, appId, page);
    }

    @DeleteMapping(value={"/favorites/{favoriteId}"})
    public void deleteFavorite(@PathVariable long favoriteId) {
        this.favoriteService.deleteFavorite(favoriteId);
    }

    @PutMapping(value={"/favorites/{favoriteId}"})
    public void toTop(@PathVariable long favoriteId) {
        this.favoriteService.adjustFavoriteToFirst(favoriteId);
    }
}

