/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.controller;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.portal.service.ConfigsImportService;
import com.ctrip.framework.apollo.portal.util.ConfigFileUtils;
import java.io.IOException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class ConfigsImportController {
    private final ConfigsImportService configsImportService;

    public ConfigsImportController(ConfigsImportService configsImportService) {
        this.configsImportService = configsImportService;
    }

    @PreAuthorize(value="@permissionValidator.hasModifyNamespacePermission(#appId, #namespaceName, #env)")
    @PostMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName}/items/import"})
    public void importConfigFile(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, @RequestParam(value="file") MultipartFile file) throws IOException {
        ConfigFileUtils.check(file);
        String format = ConfigFileUtils.getFormat(file.getOriginalFilename());
        String standardFilename = ConfigFileUtils.toFilename(appId, clusterName, namespaceName, ConfigFileFormat.fromString((String)format));
        this.configsImportService.importOneConfigFromFile(env, standardFilename, file.getInputStream());
    }
}

