/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.controller;

import com.ctrip.framework.apollo.common.exception.ServiceException;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.portal.entity.bo.NamespaceBO;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.ConfigsExportService;
import com.ctrip.framework.apollo.portal.service.NamespaceService;
import com.ctrip.framework.apollo.portal.util.NamespaceBOUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ConfigsExportController {
    private static final Logger logger = LoggerFactory.getLogger(ConfigsExportController.class);
    private final ConfigsExportService configsExportService;
    private final NamespaceService namespaceService;

    public ConfigsExportController(ConfigsExportService configsExportService, @Lazy NamespaceService namespaceService) {
        this.configsExportService = configsExportService;
        this.namespaceService = namespaceService;
    }

    @PreAuthorize(value="!@permissionValidator.shouldHideConfigToCurrentUser(#appId, #env, #namespaceName)")
    @GetMapping(value={"/apps/{appId}/envs/{env}/clusters/{clusterName}/namespaces/{namespaceName}/items/export"})
    public void exportItems(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, HttpServletResponse res) {
        List fileNameSplit = Splitter.on((String)".").splitToList((CharSequence)namespaceName);
        String fileName = fileNameSplit.size() <= 1 ? Joiner.on((String)".").join((Object)namespaceName, (Object)ConfigFileFormat.Properties.getValue(), new Object[0]) : namespaceName;
        NamespaceBO namespaceBO = this.namespaceService.loadNamespaceBO(appId, Env.valueOf(env), clusterName, namespaceName);
        res.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        String configFileContent = NamespaceBOUtils.convert2configFileContent(namespaceBO);
        try {
            res.getOutputStream().write(configFileContent.getBytes());
        }
        catch (Exception e) {
            throw new ServiceException("export items failed:{}", e);
        }
    }

    @GetMapping(value={"/export"})
    public void exportAll(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filename = "apollo_config_export_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy_MMdd_HH_mm_ss") + ".zip";
        logger.info("Download configs, remote addr [{}], remote host [{}]. Filename is [{}]", new Object[]{request.getRemoteAddr(), request.getRemoteHost(), filename});
        response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.configsExportService.exportAllTo((OutputStream)outputStream);
        }
    }
}

