/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.controller;

import com.ctrip.framework.apollo.common.dto.ClusterDTO;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.ClusterService;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ClusterController {
    private final ClusterService clusterService;
    private final UserInfoHolder userInfoHolder;

    public ClusterController(ClusterService clusterService, UserInfoHolder userInfoHolder) {
        this.clusterService = clusterService;
        this.userInfoHolder = userInfoHolder;
    }

    @PreAuthorize(value="@permissionValidator.hasCreateClusterPermission(#appId)")
    @PostMapping(value={"apps/{appId}/envs/{env}/clusters"})
    public ClusterDTO createCluster(@PathVariable String appId, @PathVariable String env, @Valid @RequestBody ClusterDTO cluster) {
        String operator = this.userInfoHolder.getUser().getUserId();
        cluster.setDataChangeLastModifiedBy(operator);
        cluster.setDataChangeCreatedBy(operator);
        return this.clusterService.createCluster(Env.valueOf(env), cluster);
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @DeleteMapping(value={"apps/{appId}/envs/{env}/clusters/{clusterName:.+}"})
    public ResponseEntity<Void> deleteCluster(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName) {
        this.clusterService.deleteCluster(Env.fromString(env), appId, clusterName);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"apps/{appId}/envs/{env}/clusters/{clusterName:.+}"})
    public ClusterDTO loadCluster(@PathVariable(value="appId") String appId, @PathVariable String env, @PathVariable(value="clusterName") String clusterName) {
        return this.clusterService.loadCluster(appId, Env.fromString(env), clusterName);
    }
}

