/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.controller;

import com.ctrip.framework.apollo.common.dto.PageDTO;
import com.ctrip.framework.apollo.common.entity.App;
import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.common.http.MultiResponseEntity;
import com.ctrip.framework.apollo.common.http.RichResponseEntity;
import com.ctrip.framework.apollo.portal.component.PortalSettings;
import com.ctrip.framework.apollo.portal.entity.model.AppModel;
import com.ctrip.framework.apollo.portal.entity.po.Role;
import com.ctrip.framework.apollo.portal.entity.vo.EnvClusterInfo;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.listener.AppCreationEvent;
import com.ctrip.framework.apollo.portal.listener.AppDeletionEvent;
import com.ctrip.framework.apollo.portal.listener.AppInfoChangedEvent;
import com.ctrip.framework.apollo.portal.service.AppService;
import com.ctrip.framework.apollo.portal.service.RoleInitializationService;
import com.ctrip.framework.apollo.portal.service.RolePermissionService;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.portal.util.RoleUtils;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;

@RestController
@RequestMapping(value={"/apps"})
public class AppController {
    private final UserInfoHolder userInfoHolder;
    private final AppService appService;
    private final PortalSettings portalSettings;
    private final ApplicationEventPublisher publisher;
    private final RolePermissionService rolePermissionService;
    private final RoleInitializationService roleInitializationService;

    public AppController(UserInfoHolder userInfoHolder, AppService appService, PortalSettings portalSettings, ApplicationEventPublisher publisher, RolePermissionService rolePermissionService, RoleInitializationService roleInitializationService) {
        this.userInfoHolder = userInfoHolder;
        this.appService = appService;
        this.portalSettings = portalSettings;
        this.publisher = publisher;
        this.rolePermissionService = rolePermissionService;
        this.roleInitializationService = roleInitializationService;
    }

    @GetMapping
    public List<App> findApps(@RequestParam(value="appIds", required=false) String appIds) {
        if (StringUtils.isEmpty((Object)appIds)) {
            return this.appService.findAll();
        }
        return this.appService.findByAppIds(Sets.newHashSet((Object[])appIds.split(",")));
    }

    @GetMapping(value={"/search/by-appid-or-name"})
    public PageDTO<App> searchByAppIdOrAppName(@RequestParam(value="query", required=false) String query, Pageable pageable) {
        if (StringUtils.isEmpty((Object)query)) {
            return this.appService.findAll(pageable);
        }
        return this.appService.searchByAppIdOrAppName(query, pageable);
    }

    @GetMapping(value={"/by-owner"})
    public List<App> findAppsByOwner(@RequestParam(value="owner") String owner, Pageable page) {
        HashSet appIds = Sets.newHashSet();
        List<Role> userRoles = this.rolePermissionService.findUserRoles(owner);
        for (Role role : userRoles) {
            String appId = RoleUtils.extractAppIdFromRoleName(role.getRoleName());
            if (appId == null) continue;
            appIds.add(appId);
        }
        return this.appService.findByAppIds(appIds, page);
    }

    @PreAuthorize(value="@permissionValidator.hasCreateApplicationPermission()")
    @PostMapping
    public App create(@Valid @RequestBody AppModel appModel) {
        App app = this.transformToApp(appModel);
        App createdApp = this.appService.createAppInLocal(app);
        this.publisher.publishEvent((ApplicationEvent)new AppCreationEvent(createdApp));
        Set<String> admins = appModel.getAdmins();
        if (!CollectionUtils.isEmpty(admins)) {
            this.rolePermissionService.assignRoleToUsers(RoleUtils.buildAppMasterRoleName(createdApp.getAppId()), admins, this.userInfoHolder.getUser().getUserId());
        }
        return createdApp;
    }

    @PreAuthorize(value="@permissionValidator.isAppAdmin(#appId)")
    @PutMapping(value={"/{appId:.+}"})
    public void update(@PathVariable String appId, @Valid @RequestBody AppModel appModel) {
        if (!Objects.equals(appId, appModel.getAppId())) {
            throw new BadRequestException("The App Id of path variable and request body is different");
        }
        App app = this.transformToApp(appModel);
        App updatedApp = this.appService.updateAppInLocal(app);
        this.publisher.publishEvent((ApplicationEvent)new AppInfoChangedEvent(updatedApp));
    }

    @GetMapping(value={"/{appId}/navtree"})
    public MultiResponseEntity<EnvClusterInfo> nav(@PathVariable String appId) {
        MultiResponseEntity response = MultiResponseEntity.ok();
        List<Env> envs = this.portalSettings.getActiveEnvs();
        for (Env env : envs) {
            try {
                response.addResponseEntity(RichResponseEntity.ok((Object)this.appService.createEnvNavNode(env, appId)));
            }
            catch (Exception e) {
                response.addResponseEntity(RichResponseEntity.error((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (Object)("load env:" + env.name() + " cluster error." + e.getMessage())));
            }
        }
        return response;
    }

    @PostMapping(value={"/envs/{env}"}, consumes={"application/json"})
    public ResponseEntity<Void> create(@PathVariable String env, @Valid @RequestBody App app) {
        this.appService.createAppInRemote(Env.valueOf(env), app);
        this.roleInitializationService.initNamespaceSpecificEnvRoles(app.getAppId(), "application", env, this.userInfoHolder.getUser().getUserId());
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{appId:.+}"})
    public App load(@PathVariable String appId) {
        return this.appService.load(appId);
    }

    @PreAuthorize(value="@permissionValidator.isSuperAdmin()")
    @DeleteMapping(value={"/{appId:.+}"})
    public void deleteApp(@PathVariable String appId) {
        App app = this.appService.deleteAppInLocal(appId);
        this.publisher.publishEvent((ApplicationEvent)new AppDeletionEvent(app));
    }

    @GetMapping(value={"/{appId}/miss_envs"})
    public MultiResponseEntity<String> findMissEnvs(@PathVariable String appId) {
        MultiResponseEntity response = MultiResponseEntity.ok();
        for (Env env : this.portalSettings.getActiveEnvs()) {
            try {
                this.appService.load(env, appId);
            }
            catch (Exception e) {
                if (e instanceof HttpClientErrorException && ((HttpClientErrorException)e).getStatusCode() == HttpStatus.NOT_FOUND) {
                    response.addResponseEntity(RichResponseEntity.ok((Object)env.toString()));
                    continue;
                }
                response.addResponseEntity(RichResponseEntity.error((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (Object)(String.format("load appId:%s from env %s error.", appId, env) + e.getMessage())));
            }
        }
        return response;
    }

    private App transformToApp(AppModel appModel) {
        String appId = appModel.getAppId();
        String appName = appModel.getName();
        String ownerName = appModel.getOwnerName();
        String orgId = appModel.getOrgId();
        String orgName = appModel.getOrgName();
        return App.builder().appId(appId).name(appName).ownerName(ownerName).orgId(orgId).orgName(orgName).build();
    }
}

