/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.component.txtresolver;

import com.ctrip.framework.apollo.common.dto.ItemChangeSets;
import com.ctrip.framework.apollo.common.dto.ItemDTO;
import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.portal.component.txtresolver.ConfigTextResolver;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="propertyResolver")
public class PropertyResolver
implements ConfigTextResolver {
    private static final String KV_SEPARATOR = "=";
    private static final String ITEM_SEPARATOR = "\n";

    @Override
    public ItemChangeSets resolve(long namespaceId, String configText, List<ItemDTO> baseItems) {
        Map oldLineNumMapItem = BeanUtils.mapByKey((String)"lineNum", baseItems);
        Map oldKeyMapItem = BeanUtils.mapByKey((String)"key", baseItems);
        oldKeyMapItem.remove("");
        String[] newItems = configText.split(ITEM_SEPARATOR);
        if (this.isHasRepeatKey(newItems)) {
            throw new BadRequestException("config text has repeat key please check.");
        }
        ItemChangeSets changeSets = new ItemChangeSets();
        HashMap<Integer, String> newLineNumMapItem = new HashMap<Integer, String>();
        int lineCounter = 1;
        for (String newItem : newItems) {
            newItem = newItem.trim();
            newLineNumMapItem.put(lineCounter, newItem);
            ItemDTO oldItemByLine = (ItemDTO)oldLineNumMapItem.get(lineCounter);
            if (this.isCommentItem(newItem)) {
                this.handleCommentLine(namespaceId, oldItemByLine, newItem, lineCounter, changeSets);
            } else if (this.isBlankItem(newItem)) {
                this.handleBlankLine(namespaceId, oldItemByLine, lineCounter, changeSets);
            } else {
                this.handleNormalLine(namespaceId, oldKeyMapItem, newItem, lineCounter, changeSets);
            }
            ++lineCounter;
        }
        this.deleteCommentAndBlankItem(oldLineNumMapItem, newLineNumMapItem, changeSets);
        this.deleteNormalKVItem(oldKeyMapItem, changeSets);
        return changeSets;
    }

    private boolean isHasRepeatKey(String[] newItems) {
        HashSet<String> keys = new HashSet<String>();
        int lineCounter = 1;
        int keyCount = 0;
        for (String item : newItems) {
            if (!this.isCommentItem(item) && !this.isBlankItem(item)) {
                ++keyCount;
                String[] kv = this.parseKeyValueFromItem(item);
                if (kv != null) {
                    keys.add(kv[0].toLowerCase());
                } else {
                    throw new BadRequestException("line:" + lineCounter + " key value must separate by '='");
                }
            }
            ++lineCounter;
        }
        return keyCount > keys.size();
    }

    private String[] parseKeyValueFromItem(String item) {
        int kvSeparator = item.indexOf(KV_SEPARATOR);
        if (kvSeparator == -1) {
            return null;
        }
        String[] kv = new String[]{item.substring(0, kvSeparator).trim(), item.substring(kvSeparator + 1, item.length()).trim()};
        return kv;
    }

    private void handleCommentLine(Long namespaceId, ItemDTO oldItemByLine, String newItem, int lineCounter, ItemChangeSets changeSets) {
        String oldComment;
        String string = oldComment = oldItemByLine == null ? "" : oldItemByLine.getComment();
        if (!this.isCommentItem(oldItemByLine) || !newItem.equals(oldComment)) {
            changeSets.addCreateItem(this.buildCommentItem(0L, namespaceId, newItem, lineCounter));
        }
    }

    private void handleBlankLine(Long namespaceId, ItemDTO oldItem, int lineCounter, ItemChangeSets changeSets) {
        if (!this.isBlankItem(oldItem)) {
            changeSets.addCreateItem(this.buildBlankItem(0L, namespaceId, lineCounter));
        }
    }

    private void handleNormalLine(Long namespaceId, Map<String, ItemDTO> keyMapOldItem, String newItem, int lineCounter, ItemChangeSets changeSets) {
        String[] kv = this.parseKeyValueFromItem(newItem);
        if (kv == null) {
            throw new BadRequestException("line:" + lineCounter + " key value must separate by '='");
        }
        String newKey = kv[0];
        String newValue = kv[1].replace("\\n", ITEM_SEPARATOR);
        ItemDTO oldItem = keyMapOldItem.get(newKey);
        if (oldItem == null) {
            changeSets.addCreateItem(this.buildNormalItem(0L, namespaceId, newKey, newValue, "", lineCounter));
        } else if (!newValue.equals(oldItem.getValue()) || lineCounter != oldItem.getLineNum()) {
            changeSets.addUpdateItem(this.buildNormalItem(oldItem.getId(), namespaceId, newKey, newValue, oldItem.getComment(), lineCounter));
        }
        keyMapOldItem.remove(newKey);
    }

    private boolean isCommentItem(ItemDTO item) {
        return item != null && "".equals(item.getKey()) && (item.getComment().startsWith("#") || item.getComment().startsWith("!"));
    }

    private boolean isCommentItem(String line) {
        return line != null && (line.startsWith("#") || line.startsWith("!"));
    }

    private boolean isBlankItem(ItemDTO item) {
        return item != null && "".equals(item.getKey()) && "".equals(item.getComment());
    }

    private boolean isBlankItem(String line) {
        return Strings.nullToEmpty((String)line).trim().isEmpty();
    }

    private void deleteNormalKVItem(Map<String, ItemDTO> baseKeyMapItem, ItemChangeSets changeSets) {
        for (Map.Entry<String, ItemDTO> entry : baseKeyMapItem.entrySet()) {
            changeSets.addDeleteItem(entry.getValue());
        }
    }

    private void deleteCommentAndBlankItem(Map<Integer, ItemDTO> oldLineNumMapItem, Map<Integer, String> newLineNumMapItem, ItemChangeSets changeSets) {
        for (Map.Entry<Integer, ItemDTO> entry : oldLineNumMapItem.entrySet()) {
            int lineNum = entry.getKey();
            ItemDTO oldItem = entry.getValue();
            String newItem = newLineNumMapItem.get(lineNum);
            if ((!this.isBlankItem(oldItem) || this.isBlankItem(newItem)) && (!this.isCommentItem(oldItem) || newItem != null && newItem.equals(oldItem.getComment()))) continue;
            changeSets.addDeleteItem(oldItem);
        }
    }

    private ItemDTO buildCommentItem(Long id, Long namespaceId, String comment, int lineNum) {
        return this.buildNormalItem(id, namespaceId, "", "", comment, lineNum);
    }

    private ItemDTO buildBlankItem(Long id, Long namespaceId, int lineNum) {
        return this.buildNormalItem(id, namespaceId, "", "", "", lineNum);
    }

    private ItemDTO buildNormalItem(Long id, Long namespaceId, String key, String value, String comment, int lineNum) {
        ItemDTO item = new ItemDTO(key, value, comment, lineNum);
        item.setId(id.longValue());
        item.setNamespaceId(namespaceId.longValue());
        return item;
    }
}

