/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.component.txtresolver;

import com.ctrip.framework.apollo.common.dto.ItemChangeSets;
import com.ctrip.framework.apollo.common.dto.ItemDTO;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.portal.component.txtresolver.ConfigTextResolver;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="fileTextResolver")
public class FileTextResolver
implements ConfigTextResolver {
    @Override
    public ItemChangeSets resolve(long namespaceId, String configText, List<ItemDTO> baseItems) {
        ItemChangeSets changeSets = new ItemChangeSets();
        if (CollectionUtils.isEmpty(baseItems) && StringUtils.isEmpty((String)configText)) {
            return changeSets;
        }
        if (CollectionUtils.isEmpty(baseItems)) {
            changeSets.addCreateItem(this.createItem(namespaceId, 0L, configText));
        } else {
            ItemDTO beforeItem = baseItems.get(0);
            if (!configText.equals(beforeItem.getValue())) {
                changeSets.addUpdateItem(this.createItem(namespaceId, beforeItem.getId(), configText));
            }
        }
        return changeSets;
    }

    private ItemDTO createItem(long namespaceId, long itemId, String value) {
        ItemDTO item = new ItemDTO();
        item.setId(itemId);
        item.setNamespaceId(namespaceId);
        item.setValue(value);
        item.setLineNum(1);
        item.setKey("content");
        return item;
    }
}

