/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.component.emailbuilder;

import com.ctrip.framework.apollo.common.constants.GsonType;
import com.ctrip.framework.apollo.common.dto.GrayReleaseRuleItemDTO;
import com.ctrip.framework.apollo.portal.component.emailbuilder.ConfigPublishEmailBuilder;
import com.ctrip.framework.apollo.portal.entity.bo.ReleaseHistoryBO;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.google.common.base.Joiner;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class GrayPublishEmailBuilder
extends ConfigPublishEmailBuilder {
    private static final String EMAIL_SUBJECT = "[Apollo] \u7070\u5ea6\u53d1\u5e03";
    private Gson gson = new Gson();
    private Joiner IP_JOINER = Joiner.on((String)", ");

    @Override
    protected String subject() {
        return EMAIL_SUBJECT;
    }

    @Override
    public String emailContent(Env env, ReleaseHistoryBO releaseHistory) {
        String result = this.renderEmailCommonContent(env, releaseHistory);
        return this.renderGrayReleaseRuleContent(result, releaseHistory);
    }

    @Override
    protected String getTemplateFramework() {
        return this.portalConfig.emailTemplateFramework();
    }

    @Override
    protected String getDiffModuleTemplate() {
        return this.portalConfig.emailReleaseDiffModuleTemplate();
    }

    private String renderGrayReleaseRuleContent(String bodyTemplate, ReleaseHistoryBO releaseHistory) {
        List ruleItems;
        Map<String, Object> context = releaseHistory.getOperationContext();
        Object rules = context.get("rules");
        List list = ruleItems = rules == null ? null : (List)this.gson.fromJson(rules.toString(), GsonType.RULE_ITEMS);
        if (CollectionUtils.isEmpty(ruleItems)) {
            return bodyTemplate.replaceAll("#\\{rulesModule}", "<br><h4>\u65e0\u7070\u5ea6\u89c4\u5219</h4>");
        }
        StringBuilder rulesHtmlBuilder = new StringBuilder();
        for (GrayReleaseRuleItemDTO ruleItem : ruleItems) {
            String clientAppId = ruleItem.getClientAppId();
            Set ips = ruleItem.getClientIpList();
            rulesHtmlBuilder.append("<b>AppId:&nbsp;</b>").append(clientAppId).append("&nbsp;&nbsp; <b>IP:&nbsp;</b>");
            this.IP_JOINER.appendTo(rulesHtmlBuilder, (Iterable)ips);
        }
        String grayRulesModuleContent = this.portalConfig.emailGrayRulesModuleTemplate().replaceAll("#\\{rulesContent}", Matcher.quoteReplacement(rulesHtmlBuilder.toString()));
        return bodyTemplate.replaceAll("#\\{rulesModule}", Matcher.quoteReplacement(grayRulesModuleContent));
    }
}

