/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.component.emailbuilder;

import com.ctrip.framework.apollo.common.dto.ReleaseDTO;
import com.ctrip.framework.apollo.common.entity.AppNamespace;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.entity.bo.Email;
import com.ctrip.framework.apollo.portal.entity.bo.KVEntity;
import com.ctrip.framework.apollo.portal.entity.bo.ReleaseHistoryBO;
import com.ctrip.framework.apollo.portal.entity.bo.UserInfo;
import com.ctrip.framework.apollo.portal.entity.vo.Change;
import com.ctrip.framework.apollo.portal.entity.vo.ReleaseCompareResult;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.AppNamespaceService;
import com.ctrip.framework.apollo.portal.service.ReleaseService;
import com.ctrip.framework.apollo.portal.service.RolePermissionService;
import com.ctrip.framework.apollo.portal.spi.UserService;
import com.ctrip.framework.apollo.portal.util.RoleUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang.time.FastDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class ConfigPublishEmailBuilder {
    private static final String EMERGENCY_PUBLISH_TAG = "<span style='color:red'>(\u7d27\u6025\u53d1\u5e03)</span>";
    private static final String EMAIL_CONTENT_FIELD_APPID = "#\\{appId\\}";
    private static final String EMAIL_CONTENT_FIELD_ENV = "#\\{env}";
    private static final String EMAIL_CONTENT_FIELD_CLUSTER = "#\\{clusterName}";
    private static final String EMAIL_CONTENT_FIELD_NAMESPACE = "#\\{namespaceName}";
    private static final String EMAIL_CONTENT_FIELD_OPERATOR = "#\\{operator}";
    private static final String EMAIL_CONTENT_FIELD_RELEASE_TIME = "#\\{releaseTime}";
    private static final String EMAIL_CONTENT_FIELD_RELEASE_ID = "#\\{releaseId}";
    private static final String EMAIL_CONTENT_FIELD_RELEASE_HISTORY_ID = "#\\{releaseHistoryId}";
    private static final String EMAIL_CONTENT_FIELD_RELEASE_TITLE = "#\\{releaseTitle}";
    private static final String EMAIL_CONTENT_FIELD_RELEASE_COMMENT = "#\\{releaseComment}";
    private static final String EMAIL_CONTENT_FIELD_APOLLO_SERVER_ADDRESS = "#\\{apollo.portal.address}";
    private static final String EMAIL_CONTENT_FIELD_DIFF_CONTENT = "#\\{diffContent}";
    private static final String EMAIL_CONTENT_FIELD_EMERGENCY_PUBLISH = "#\\{emergencyPublish}";
    private static final String EMAIL_CONTENT_DIFF_MODULE = "#\\{diffModule}";
    protected static final String EMAIL_CONTENT_GRAY_RULES_MODULE = "#\\{rulesModule}";
    protected static final String EMAIL_CONTENT_GRAY_RULES_CONTENT = "#\\{rulesContent}";
    protected static final int VALUE_MAX_LENGTH = 100;
    protected FastDateFormat dateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    @Autowired
    private RolePermissionService rolePermissionService;
    @Autowired
    private ReleaseService releaseService;
    @Autowired
    private AppNamespaceService appNamespaceService;
    @Autowired
    private UserService userService;
    @Autowired
    protected PortalConfig portalConfig;

    protected abstract String subject();

    protected abstract String emailContent(Env var1, ReleaseHistoryBO var2);

    protected abstract String getTemplateFramework();

    protected abstract String getDiffModuleTemplate();

    public Email build(Env env, ReleaseHistoryBO releaseHistory) {
        Email email = new Email();
        email.setSubject(this.subject());
        email.setSenderEmailAddress(this.portalConfig.emailSender());
        email.setRecipients(this.recipients(releaseHistory.getAppId(), releaseHistory.getNamespaceName(), env.toString()));
        String emailBody = this.emailContent(env, releaseHistory);
        emailBody = emailBody.replaceAll(EMAIL_CONTENT_DIFF_MODULE, "");
        emailBody = emailBody.replaceAll(EMAIL_CONTENT_GRAY_RULES_MODULE, "");
        email.setBody(emailBody);
        return email;
    }

    protected String renderEmailCommonContent(Env env, ReleaseHistoryBO releaseHistory) {
        String template = this.getTemplateFramework();
        String renderResult = this.renderReleaseBasicInfo(template, env, releaseHistory);
        renderResult = this.renderDiffModule(renderResult, env, releaseHistory);
        return renderResult;
    }

    private String renderReleaseBasicInfo(String template, Env env, ReleaseHistoryBO releaseHistory) {
        String renderResult = template;
        Map<String, Object> operationContext = releaseHistory.getOperationContext();
        boolean isEmergencyPublish = operationContext.containsKey("isEmergencyPublish") && (Boolean)operationContext.get("isEmergencyPublish") != false;
        renderResult = isEmergencyPublish ? renderResult.replaceAll(EMAIL_CONTENT_FIELD_EMERGENCY_PUBLISH, Matcher.quoteReplacement(EMERGENCY_PUBLISH_TAG)) : renderResult.replaceAll(EMAIL_CONTENT_FIELD_EMERGENCY_PUBLISH, "");
        renderResult = renderResult.replaceAll(EMAIL_CONTENT_FIELD_APPID, Matcher.quoteReplacement(releaseHistory.getAppId()));
        renderResult = renderResult.replaceAll(EMAIL_CONTENT_FIELD_ENV, Matcher.quoteReplacement(env.toString()));
        renderResult = renderResult.replaceAll(EMAIL_CONTENT_FIELD_CLUSTER, Matcher.quoteReplacement(releaseHistory.getClusterName()));
        renderResult = renderResult.replaceAll(EMAIL_CONTENT_FIELD_NAMESPACE, Matcher.quoteReplacement(releaseHistory.getNamespaceName()));
        renderResult = renderResult.replaceAll(EMAIL_CONTENT_FIELD_OPERATOR, Matcher.quoteReplacement(releaseHistory.getOperator()));
        renderResult = renderResult.replaceAll(EMAIL_CONTENT_FIELD_RELEASE_TITLE, Matcher.quoteReplacement(releaseHistory.getReleaseTitle()));
        renderResult = renderResult.replaceAll(EMAIL_CONTENT_FIELD_RELEASE_ID, String.valueOf(releaseHistory.getReleaseId()));
        renderResult = renderResult.replaceAll(EMAIL_CONTENT_FIELD_RELEASE_HISTORY_ID, String.valueOf(releaseHistory.getId()));
        renderResult = renderResult.replaceAll(EMAIL_CONTENT_FIELD_RELEASE_COMMENT, Matcher.quoteReplacement(releaseHistory.getReleaseComment() == null ? "" : releaseHistory.getReleaseComment()));
        renderResult = renderResult.replaceAll(EMAIL_CONTENT_FIELD_APOLLO_SERVER_ADDRESS, this.getApolloPortalAddress());
        return renderResult.replaceAll(EMAIL_CONTENT_FIELD_RELEASE_TIME, this.dateFormat.format(releaseHistory.getReleaseTime()));
    }

    private String renderDiffModule(String bodyTemplate, Env env, ReleaseHistoryBO releaseHistory) {
        String namespaceName;
        String appId = releaseHistory.getAppId();
        AppNamespace appNamespace = this.appNamespaceService.findByAppIdAndName(appId, namespaceName = releaseHistory.getNamespaceName());
        if (appNamespace == null) {
            appNamespace = this.appNamespaceService.findPublicAppNamespace(namespaceName);
        }
        if (appNamespace == null || !appNamespace.getFormat().equals(ConfigFileFormat.Properties.getValue())) {
            return bodyTemplate.replaceAll(EMAIL_CONTENT_DIFF_MODULE, "<br><h4>\u53d8\u66f4\u5185\u5bb9\u8bf7\u70b9\u51fb\u94fe\u63a5\u5230Apollo\u4e0a\u67e5\u770b</h4>");
        }
        ReleaseCompareResult result = this.getReleaseCompareResult(env, releaseHistory);
        if (!result.hasContent()) {
            return bodyTemplate.replaceAll(EMAIL_CONTENT_DIFF_MODULE, "<br><h4>\u65e0\u914d\u7f6e\u53d8\u66f4</h4>");
        }
        List<Change> changes = result.getChanges();
        StringBuilder changesHtmlBuilder = new StringBuilder();
        for (Change change : changes) {
            String key = ((KVEntity)change.getEntity().getFirstEntity()).getKey();
            String oldValue = ((KVEntity)change.getEntity().getFirstEntity()).getValue();
            String newValue = ((KVEntity)change.getEntity().getSecondEntity()).getValue();
            newValue = newValue == null ? "" : newValue;
            changesHtmlBuilder.append("<tr>");
            changesHtmlBuilder.append("<td width=\"10%\">").append(change.getType().toString()).append("</td>");
            changesHtmlBuilder.append("<td width=\"20%\">").append(this.cutOffString(key)).append("</td>");
            changesHtmlBuilder.append("<td width=\"35%\">").append(this.cutOffString(oldValue)).append("</td>");
            changesHtmlBuilder.append("<td width=\"35%\">").append(this.cutOffString(newValue)).append("</td>");
            changesHtmlBuilder.append("</tr>");
        }
        String diffContent = Matcher.quoteReplacement(changesHtmlBuilder.toString());
        String diffModuleTemplate = this.getDiffModuleTemplate();
        String diffModuleRenderResult = diffModuleTemplate.replaceAll(EMAIL_CONTENT_FIELD_DIFF_CONTENT, diffContent);
        return bodyTemplate.replaceAll(EMAIL_CONTENT_DIFF_MODULE, diffModuleRenderResult);
    }

    private ReleaseCompareResult getReleaseCompareResult(Env env, ReleaseHistoryBO releaseHistory) {
        if (releaseHistory.getOperation() == 2 && releaseHistory.getPreviousReleaseId() == 0L) {
            ReleaseDTO masterLatestActiveRelease = this.releaseService.loadLatestRelease(releaseHistory.getAppId(), env, releaseHistory.getClusterName(), releaseHistory.getNamespaceName());
            ReleaseDTO branchLatestActiveRelease = this.releaseService.findReleaseById(env, releaseHistory.getReleaseId());
            return this.releaseService.compare(masterLatestActiveRelease, branchLatestActiveRelease);
        }
        return this.releaseService.compare(env, releaseHistory.getPreviousReleaseId(), releaseHistory.getReleaseId());
    }

    private List<String> recipients(String appId, String namespaceName, String env) {
        Set<UserInfo> modifyRoleUsers = this.rolePermissionService.queryUsersWithRole(RoleUtils.buildNamespaceRoleName(appId, namespaceName, "ModifyNamespace"));
        Set<UserInfo> envModifyRoleUsers = this.rolePermissionService.queryUsersWithRole(RoleUtils.buildNamespaceRoleName(appId, namespaceName, "ModifyNamespace", env));
        Set<UserInfo> releaseRoleUsers = this.rolePermissionService.queryUsersWithRole(RoleUtils.buildNamespaceRoleName(appId, namespaceName, "ReleaseNamespace"));
        Set<UserInfo> envReleaseRoleUsers = this.rolePermissionService.queryUsersWithRole(RoleUtils.buildNamespaceRoleName(appId, namespaceName, "ReleaseNamespace", env));
        Set<UserInfo> owners = this.rolePermissionService.queryUsersWithRole(RoleUtils.buildAppMasterRoleName(appId));
        HashSet<String> userIds = new HashSet<String>(modifyRoleUsers.size() + releaseRoleUsers.size() + owners.size());
        for (UserInfo userInfo : modifyRoleUsers) {
            userIds.add(userInfo.getUserId());
        }
        for (UserInfo userInfo : envModifyRoleUsers) {
            userIds.add(userInfo.getUserId());
        }
        for (UserInfo userInfo : releaseRoleUsers) {
            userIds.add(userInfo.getUserId());
        }
        for (UserInfo userInfo : envReleaseRoleUsers) {
            userIds.add(userInfo.getUserId());
        }
        for (UserInfo userInfo : owners) {
            userIds.add(userInfo.getUserId());
        }
        List<UserInfo> userInfos = this.userService.findByUserIds(Lists.newArrayList(userIds));
        if (CollectionUtils.isEmpty(userInfos)) {
            return Collections.emptyList();
        }
        ArrayList<String> recipients = new ArrayList<String>(userInfos.size());
        for (UserInfo userInfo : userInfos) {
            recipients.add(userInfo.getEmail());
        }
        return recipients;
    }

    protected String getApolloPortalAddress() {
        return this.portalConfig.portalAddress();
    }

    private String cutOffString(String source) {
        if (source.length() > 100) {
            return source.substring(0, 100) + "...";
        }
        return source;
    }
}

