/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.component.config;

import com.ctrip.framework.apollo.common.config.RefreshableConfig;
import com.ctrip.framework.apollo.common.config.RefreshablePropertySource;
import com.ctrip.framework.apollo.portal.entity.vo.Organization;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.PortalDBPropertySource;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PortalConfig
extends RefreshableConfig {
    private static final Logger logger = LoggerFactory.getLogger(PortalConfig.class);
    private Gson gson = new Gson();
    private static final Type ORGANIZATION = new TypeToken<List<Organization>>(){}.getType();
    private static final Type META_SERVERS = new TypeToken<Map<String, String>>(){}.getType();
    private final PortalDBPropertySource portalDBPropertySource;

    public PortalConfig(PortalDBPropertySource portalDBPropertySource) {
        this.portalDBPropertySource = portalDBPropertySource;
    }

    public List<RefreshablePropertySource> getRefreshablePropertySources() {
        return Collections.singletonList(this.portalDBPropertySource);
    }

    public List<Env> portalSupportedEnvs() {
        String[] configurations = this.getArrayProperty("apollo.portal.envs", new String[]{"FAT", "UAT", "PRO"});
        LinkedList envs = Lists.newLinkedList();
        for (String env : configurations) {
            envs.add(Env.addEnvironment(env));
        }
        return envs;
    }

    public Map<String, String> getMetaServers() {
        String key = "apollo.portal.meta.servers";
        String jsonContent = this.getValue("apollo.portal.meta.servers");
        if (null == jsonContent) {
            return Collections.emptyMap();
        }
        Map map = Collections.emptyMap();
        try {
            map = (Map)this.gson.fromJson(jsonContent, META_SERVERS);
        }
        catch (Exception e) {
            logger.error("Wrong format for: {}", (Object)"apollo.portal.meta.servers", (Object)e);
        }
        return map;
    }

    public List<String> superAdmins() {
        String superAdminConfig = this.getValue("superAdmin", "");
        if (Strings.isNullOrEmpty((String)superAdminConfig)) {
            return Collections.emptyList();
        }
        return this.splitter.splitToList((CharSequence)superAdminConfig);
    }

    public Set<Env> emailSupportedEnvs() {
        String[] configurations = this.getArrayProperty("email.supported.envs", null);
        HashSet result = Sets.newHashSet();
        if (configurations == null || configurations.length == 0) {
            return result;
        }
        for (String env : configurations) {
            result.add(Env.fromString(env));
        }
        return result;
    }

    public boolean isConfigViewMemberOnly(String env) {
        String[] configViewMemberOnlyEnvs;
        for (String memberOnlyEnv : configViewMemberOnlyEnvs = this.getArrayProperty("configView.memberOnly.envs", new String[0])) {
            if (!memberOnlyEnv.equalsIgnoreCase(env)) continue;
            return true;
        }
        return false;
    }

    public int connectTimeout() {
        return this.getIntProperty("api.connectTimeout", 3000);
    }

    public int readTimeout() {
        return this.getIntProperty("api.readTimeout", 10000);
    }

    public List<Organization> organizations() {
        String organizations = this.getValue("organizations");
        return organizations == null ? Collections.emptyList() : (List)this.gson.fromJson(organizations, ORGANIZATION);
    }

    public String portalAddress() {
        return this.getValue("apollo.portal.address");
    }

    public boolean isEmergencyPublishAllowed(Env env) {
        String[] emergencyPublishSupportedEnvs;
        String targetEnv = env.name();
        for (String supportedEnv : emergencyPublishSupportedEnvs = this.getArrayProperty("emergencyPublish.supported.envs", new String[0])) {
            if (!Objects.equals(targetEnv, supportedEnv.toUpperCase().trim())) continue;
            return true;
        }
        return false;
    }

    public Set<Env> publishTipsSupportedEnvs() {
        String[] configurations = this.getArrayProperty("namespace.publish.tips.supported.envs", null);
        HashSet result = Sets.newHashSet();
        if (configurations == null || configurations.length == 0) {
            return result;
        }
        for (String env : configurations) {
            result.add(Env.fromString(env));
        }
        return result;
    }

    public String consumerTokenSalt() {
        return this.getValue("consumer.token.salt", "apollo-portal");
    }

    public String emailSender() {
        return this.getValue("email.sender");
    }

    public String emailTemplateFramework() {
        return this.getValue("email.template.framework", "");
    }

    public String emailReleaseDiffModuleTemplate() {
        return this.getValue("email.template.release.module.diff", "");
    }

    public String emailRollbackDiffModuleTemplate() {
        return this.getValue("email.template.rollback.module.diff", "");
    }

    public String emailGrayRulesModuleTemplate() {
        return this.getValue("email.template.release.module.rules", "");
    }

    public String wikiAddress() {
        return this.getValue("wiki.address", "https://github.com/ctripcorp/apollo/wiki");
    }

    public boolean canAppAdminCreatePrivateNamespace() {
        return this.getBooleanProperty("admin.createPrivateNamespace.switch", true);
    }

    public boolean isCreateApplicationPermissionEnabled() {
        return this.getBooleanProperty("role.create-application.enabled", false);
    }

    public boolean isManageAppMasterPermissionEnabled() {
        return this.getBooleanProperty("role.manage-app-master.enabled", false);
    }

    public String getAdminServiceAccessTokens() {
        return this.getValue("admin-service.access.tokens");
    }

    public int appId() {
        return this.getIntProperty("ctrip.appid", 0);
    }

    public String sendCode() {
        return this.getValue("ctrip.email.send.code");
    }

    public int templateId() {
        return this.getIntProperty("ctrip.email.template.id", 0);
    }

    public int survivalDuration() {
        return this.getIntProperty("ctrip.email.survival.duration", 5);
    }

    public boolean isSendEmailAsync() {
        return this.getBooleanProperty("email.send.async", true);
    }

    public String portalServerName() {
        return this.getValue("serverName");
    }

    public String casServerLoginUrl() {
        return this.getValue("casServerLoginUrl");
    }

    public String casServerUrlPrefix() {
        return this.getValue("casServerUrlPrefix");
    }

    public String credisServiceUrl() {
        return this.getValue("credisServiceUrl");
    }

    public String userServiceUrl() {
        return this.getValue("userService.url");
    }

    public String userServiceAccessToken() {
        return this.getValue("userService.accessToken");
    }

    public String soaServerAddress() {
        return this.getValue("soa.server.address");
    }

    public String cloggingUrl() {
        return this.getValue("clogging.server.url");
    }

    public String cloggingPort() {
        return this.getValue("clogging.server.port");
    }

    public String hermesServerAddress() {
        return this.getValue("hermes.server.address");
    }
}

