/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.component;

import com.ctrip.framework.apollo.common.exception.ServiceException;
import com.ctrip.framework.apollo.core.dto.ServiceDTO;
import com.ctrip.framework.apollo.portal.component.AdminServiceAddressLocator;
import com.ctrip.framework.apollo.portal.component.RestTemplateFactory;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.environment.PortalMetaDomainService;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

@Component
public class RetryableRestTemplate {
    private Logger logger = LoggerFactory.getLogger(RetryableRestTemplate.class);
    private UriTemplateHandler uriTemplateHandler = new DefaultUriBuilderFactory();
    private Gson gson = new Gson();
    private static final Type ACCESS_TOKENS = new TypeToken<Map<String, String>>(){}.getType();
    private RestTemplate restTemplate;
    private final RestTemplateFactory restTemplateFactory;
    private final AdminServiceAddressLocator adminServiceAddressLocator;
    private final PortalMetaDomainService portalMetaDomainService;
    private final PortalConfig portalConfig;
    private volatile String lastAdminServiceAccessTokens;
    private volatile Map<Env, String> adminServiceAccessTokenMap;

    public RetryableRestTemplate(@Lazy RestTemplateFactory restTemplateFactory, @Lazy AdminServiceAddressLocator adminServiceAddressLocator, PortalMetaDomainService portalMetaDomainService, PortalConfig portalConfig) {
        this.restTemplateFactory = restTemplateFactory;
        this.adminServiceAddressLocator = adminServiceAddressLocator;
        this.portalMetaDomainService = portalMetaDomainService;
        this.portalConfig = portalConfig;
    }

    @PostConstruct
    private void postConstruct() {
        this.restTemplate = this.restTemplateFactory.getObject();
    }

    public <T> T get(Env env, String path, Class<T> responseType, Object ... urlVariables) throws RestClientException {
        return this.execute(HttpMethod.GET, env, path, null, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> get(Env env, String path, ParameterizedTypeReference<T> reference, Object ... uriVariables) throws RestClientException {
        return this.exchangeGet(env, path, reference, uriVariables);
    }

    public <T> T post(Env env, String path, Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return this.execute(HttpMethod.POST, env, path, request, responseType, uriVariables);
    }

    public void put(Env env, String path, Object request, Object ... urlVariables) throws RestClientException {
        this.execute(HttpMethod.PUT, env, path, request, null, urlVariables);
    }

    public void delete(Env env, String path, Object ... urlVariables) throws RestClientException {
        this.execute(HttpMethod.DELETE, env, path, null, null, urlVariables);
    }

    private <T> T execute(HttpMethod method, Env env, String path, Object request, Class<T> responseType, Object ... uriVariables) {
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        String uri = this.uriTemplateHandler.expand(path, uriVariables).getPath();
        Transaction ct = Tracer.newTransaction((String)"AdminAPI", (String)uri);
        ct.addData("Env", (Object)env);
        List<ServiceDTO> services = this.getAdminServices(env, ct);
        HttpHeaders extraHeaders = this.assembleExtraHeaders(env);
        for (ServiceDTO serviceDTO : services) {
            try {
                T result = this.doExecute(method, extraHeaders, serviceDTO, path, request, responseType, uriVariables);
                ct.setStatus("0");
                ct.complete();
                return result;
            }
            catch (Throwable t) {
                this.logger.error("Http request failed, uri: {}, method: {}", new Object[]{uri, method, t});
                Tracer.logError((Throwable)t);
                if (this.canRetry(t, method)) {
                    Tracer.logEvent((String)"API.Retry", (String)uri);
                    continue;
                }
                ct.setStatus(t);
                ct.complete();
                throw t;
            }
        }
        ServiceException e = new ServiceException(String.format("Admin servers are unresponsive. meta server address: %s, admin servers: %s", this.portalMetaDomainService.getDomain(env), services));
        ct.setStatus((Throwable)e);
        ct.complete();
        throw e;
    }

    private <T> ResponseEntity<T> exchangeGet(Env env, String path, ParameterizedTypeReference<T> reference, Object ... uriVariables) {
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        String uri = this.uriTemplateHandler.expand(path, uriVariables).getPath();
        Transaction ct = Tracer.newTransaction((String)"AdminAPI", (String)uri);
        ct.addData("Env", (Object)env);
        List<ServiceDTO> services = this.getAdminServices(env, ct);
        HttpEntity entity = new HttpEntity((MultiValueMap)this.assembleExtraHeaders(env));
        for (ServiceDTO serviceDTO : services) {
            try {
                ResponseEntity result = this.restTemplate.exchange(this.parseHost(serviceDTO) + path, HttpMethod.GET, entity, reference, uriVariables);
                ct.setStatus("0");
                ct.complete();
                return result;
            }
            catch (Throwable t) {
                this.logger.error("Http request failed, uri: {}, method: {}", new Object[]{uri, HttpMethod.GET, t});
                Tracer.logError((Throwable)t);
                if (this.canRetry(t, HttpMethod.GET)) {
                    Tracer.logEvent((String)"API.Retry", (String)uri);
                    continue;
                }
                ct.setStatus(t);
                ct.complete();
                throw t;
            }
        }
        ServiceException e = new ServiceException(String.format("Admin servers are unresponsive. meta server address: %s, admin servers: %s", this.portalMetaDomainService.getDomain(env), services));
        ct.setStatus((Throwable)e);
        ct.complete();
        throw e;
    }

    private HttpHeaders assembleExtraHeaders(Env env) {
        String adminServiceAccessToken = this.getAdminServiceAccessToken(env);
        if (!Strings.isNullOrEmpty((String)adminServiceAccessToken)) {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Authorization", adminServiceAccessToken);
            return headers;
        }
        return null;
    }

    private List<ServiceDTO> getAdminServices(Env env, Transaction ct) {
        List<ServiceDTO> services = this.adminServiceAddressLocator.getServiceList(env);
        if (CollectionUtils.isEmpty(services)) {
            ServiceException e = new ServiceException(String.format("No available admin server. Maybe because of meta server down or all admin server down. Meta server address: %s", this.portalMetaDomainService.getDomain(env)));
            ct.setStatus((Throwable)e);
            ct.complete();
            throw e;
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAdminServiceAccessToken(Env env) {
        String accessTokens = this.portalConfig.getAdminServiceAccessTokens();
        if (Strings.isNullOrEmpty((String)accessTokens)) {
            return null;
        }
        if (!accessTokens.equals(this.lastAdminServiceAccessTokens)) {
            RetryableRestTemplate retryableRestTemplate = this;
            synchronized (retryableRestTemplate) {
                this.adminServiceAccessTokenMap = this.parseAdminServiceAccessTokens(accessTokens);
                this.lastAdminServiceAccessTokens = accessTokens;
            }
        }
        return this.adminServiceAccessTokenMap.get(env);
    }

    private Map<Env, String> parseAdminServiceAccessTokens(String accessTokens) {
        HashMap tokenMap = Maps.newHashMap();
        try {
            Map map = (Map)this.gson.fromJson(accessTokens, ACCESS_TOKENS);
            map.forEach((env, token) -> {
                if (Env.exists(env)) {
                    tokenMap.put(Env.valueOf(env), token);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Wrong format of admin service access tokens: {}", (Object)accessTokens, (Object)e);
        }
        return tokenMap;
    }

    private <T> T doExecute(HttpMethod method, HttpHeaders extraHeaders, ServiceDTO service, String path, Object request, Class<T> responseType, Object ... uriVariables) {
        Object result = null;
        switch (method) {
            case GET: 
            case POST: 
            case PUT: 
            case DELETE: {
                HttpEntity entity;
                if (request instanceof HttpEntity) {
                    entity = (HttpEntity)request;
                    if (!CollectionUtils.isEmpty((Map)extraHeaders)) {
                        HttpHeaders headers = new HttpHeaders();
                        headers.addAll((MultiValueMap)entity.getHeaders());
                        headers.addAll((MultiValueMap)extraHeaders);
                        entity = new HttpEntity(entity.getBody(), (MultiValueMap)headers);
                    }
                } else {
                    entity = new HttpEntity(request, (MultiValueMap)extraHeaders);
                }
                result = this.restTemplate.exchange(this.parseHost(service) + path, method, entity, responseType, uriVariables).getBody();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("unsupported http method(method=%s)", method));
            }
        }
        return (T)result;
    }

    private String parseHost(ServiceDTO serviceAddress) {
        return serviceAddress.getHomepageUrl() + "/";
    }

    private boolean canRetry(Throwable e, HttpMethod method) {
        Throwable nestedException = e.getCause();
        if (method == HttpMethod.GET) {
            return nestedException instanceof SocketTimeoutException || nestedException instanceof HttpHostConnectException || nestedException instanceof ConnectTimeoutException;
        }
        return nestedException instanceof HttpHostConnectException || nestedException instanceof ConnectTimeoutException;
    }
}

