/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.component;

import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.portal.api.AdminServiceAPI;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.environment.PortalMetaDomainService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class PortalSettings {
    private static final Logger logger = LoggerFactory.getLogger(PortalSettings.class);
    private static final int HEALTH_CHECK_INTERVAL = 10000;
    private final ApplicationContext applicationContext;
    private final PortalConfig portalConfig;
    private final PortalMetaDomainService portalMetaDomainService;
    private List<Env> allEnvs = new ArrayList<Env>();
    private Map<Env, Boolean> envStatusMark = new ConcurrentHashMap<Env, Boolean>();

    public PortalSettings(ApplicationContext applicationContext, PortalConfig portalConfig, PortalMetaDomainService portalMetaDomainService) {
        this.applicationContext = applicationContext;
        this.portalConfig = portalConfig;
        this.portalMetaDomainService = portalMetaDomainService;
    }

    @PostConstruct
    private void postConstruct() {
        this.allEnvs = this.portalConfig.portalSupportedEnvs();
        for (Env env : this.allEnvs) {
            this.envStatusMark.put(env, true);
        }
        ScheduledExecutorService healthCheckService = Executors.newScheduledThreadPool(1, ApolloThreadFactory.create((String)"EnvHealthChecker", (boolean)true));
        healthCheckService.scheduleWithFixedDelay(new HealthCheckTask(this.applicationContext), 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    public List<Env> getAllEnvs() {
        return this.allEnvs;
    }

    public List<Env> getActiveEnvs() {
        LinkedList<Env> activeEnvs = new LinkedList<Env>();
        for (Env env : this.allEnvs) {
            if (!this.envStatusMark.get(env).booleanValue()) continue;
            activeEnvs.add(env);
        }
        return activeEnvs;
    }

    public boolean isEnvActive(Env env) {
        Boolean mark = this.envStatusMark.get(env);
        return mark == null ? false : mark;
    }

    private class HealthCheckTask
    implements Runnable {
        private static final int ENV_DOWN_THRESHOLD = 2;
        private Map<Env, Integer> healthCheckFailedCounter = new HashMap<Env, Integer>();
        private AdminServiceAPI.HealthAPI healthAPI;

        public HealthCheckTask(ApplicationContext context) {
            this.healthAPI = (AdminServiceAPI.HealthAPI)context.getBean(AdminServiceAPI.HealthAPI.class);
            for (Env env : PortalSettings.this.allEnvs) {
                this.healthCheckFailedCounter.put(env, 0);
            }
        }

        @Override
        public void run() {
            for (Env env : PortalSettings.this.allEnvs) {
                try {
                    if (this.isUp(env)) {
                        if (((Boolean)PortalSettings.this.envStatusMark.get(env)).booleanValue()) continue;
                        PortalSettings.this.envStatusMark.put(env, true);
                        this.healthCheckFailedCounter.put(env, 0);
                        logger.info("Env revived because env health check success. env: {}", (Object)env);
                        continue;
                    }
                    logger.error("Env health check failed, maybe because of admin server down. env: {}, meta server address: {}", (Object)env, (Object)PortalSettings.this.portalMetaDomainService.getDomain(env));
                    this.handleEnvDown(env);
                }
                catch (Exception e) {
                    logger.error("Env health check failed, maybe because of meta server down or configure wrong meta server address. env: {}, meta server address: {}", new Object[]{env, PortalSettings.this.portalMetaDomainService.getDomain(env), e});
                    this.handleEnvDown(env);
                }
            }
        }

        private boolean isUp(Env env) {
            Health health = this.healthAPI.health(env);
            return "UP".equals(health.getStatus().getCode());
        }

        private void handleEnvDown(Env env) {
            int failedTimes = this.healthCheckFailedCounter.get(env);
            this.healthCheckFailedCounter.put(env, ++failedTimes);
            if (!((Boolean)PortalSettings.this.envStatusMark.get(env)).booleanValue()) {
                logger.error("Env is down. env: {}, failed times: {}, meta server address: {}", new Object[]{env, failedTimes, PortalSettings.this.portalMetaDomainService.getDomain(env)});
            } else if (failedTimes >= 2) {
                PortalSettings.this.envStatusMark.put(env, false);
                logger.error("Env is down because health check failed for {} times, which equals to down threshold. env: {}, meta server address: {}", new Object[]{2, env, PortalSettings.this.portalMetaDomainService.getDomain(env)});
            } else {
                logger.error("Env health check failed for {} times which less than down threshold. down threshold:{}, env: {}, meta server address: {}", new Object[]{failedTimes, 2, env, PortalSettings.this.portalMetaDomainService.getDomain(env)});
            }
        }
    }
}

