/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.component;

import com.ctrip.framework.apollo.common.entity.AppNamespace;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.service.AppNamespaceService;
import com.ctrip.framework.apollo.portal.service.RolePermissionService;
import com.ctrip.framework.apollo.portal.service.SystemRoleManagerService;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.portal.util.RoleUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="permissionValidator")
public class PermissionValidator {
    private final UserInfoHolder userInfoHolder;
    private final RolePermissionService rolePermissionService;
    private final PortalConfig portalConfig;
    private final AppNamespaceService appNamespaceService;
    private final SystemRoleManagerService systemRoleManagerService;

    @Autowired
    public PermissionValidator(UserInfoHolder userInfoHolder, RolePermissionService rolePermissionService, PortalConfig portalConfig, AppNamespaceService appNamespaceService, SystemRoleManagerService systemRoleManagerService) {
        this.userInfoHolder = userInfoHolder;
        this.rolePermissionService = rolePermissionService;
        this.portalConfig = portalConfig;
        this.appNamespaceService = appNamespaceService;
        this.systemRoleManagerService = systemRoleManagerService;
    }

    public boolean hasModifyNamespacePermission(String appId, String namespaceName) {
        return this.rolePermissionService.userHasPermission(this.userInfoHolder.getUser().getUserId(), "ModifyNamespace", RoleUtils.buildNamespaceTargetId(appId, namespaceName));
    }

    public boolean hasModifyNamespacePermission(String appId, String namespaceName, String env) {
        return this.hasModifyNamespacePermission(appId, namespaceName) || this.rolePermissionService.userHasPermission(this.userInfoHolder.getUser().getUserId(), "ModifyNamespace", RoleUtils.buildNamespaceTargetId(appId, namespaceName, env));
    }

    public boolean hasReleaseNamespacePermission(String appId, String namespaceName) {
        return this.rolePermissionService.userHasPermission(this.userInfoHolder.getUser().getUserId(), "ReleaseNamespace", RoleUtils.buildNamespaceTargetId(appId, namespaceName));
    }

    public boolean hasReleaseNamespacePermission(String appId, String namespaceName, String env) {
        return this.hasReleaseNamespacePermission(appId, namespaceName) || this.rolePermissionService.userHasPermission(this.userInfoHolder.getUser().getUserId(), "ReleaseNamespace", RoleUtils.buildNamespaceTargetId(appId, namespaceName, env));
    }

    public boolean hasDeleteNamespacePermission(String appId) {
        return this.hasAssignRolePermission(appId) || this.isSuperAdmin();
    }

    public boolean hasOperateNamespacePermission(String appId, String namespaceName) {
        return this.hasModifyNamespacePermission(appId, namespaceName) || this.hasReleaseNamespacePermission(appId, namespaceName);
    }

    public boolean hasOperateNamespacePermission(String appId, String namespaceName, String env) {
        return this.hasOperateNamespacePermission(appId, namespaceName) || this.hasModifyNamespacePermission(appId, namespaceName, env) || this.hasReleaseNamespacePermission(appId, namespaceName, env);
    }

    public boolean hasAssignRolePermission(String appId) {
        return this.rolePermissionService.userHasPermission(this.userInfoHolder.getUser().getUserId(), "AssignRole", appId);
    }

    public boolean hasCreateNamespacePermission(String appId) {
        return this.rolePermissionService.userHasPermission(this.userInfoHolder.getUser().getUserId(), "CreateNamespace", appId);
    }

    public boolean hasCreateAppNamespacePermission(String appId, AppNamespace appNamespace) {
        boolean isPublicAppNamespace = appNamespace.isPublic();
        if (this.portalConfig.canAppAdminCreatePrivateNamespace() || isPublicAppNamespace) {
            return this.hasCreateNamespacePermission(appId);
        }
        return this.isSuperAdmin();
    }

    public boolean hasCreateClusterPermission(String appId) {
        return this.rolePermissionService.userHasPermission(this.userInfoHolder.getUser().getUserId(), "CreateCluster", appId);
    }

    public boolean isAppAdmin(String appId) {
        return this.isSuperAdmin() || this.hasAssignRolePermission(appId);
    }

    public boolean isSuperAdmin() {
        return this.rolePermissionService.isSuperAdmin(this.userInfoHolder.getUser().getUserId());
    }

    public boolean shouldHideConfigToCurrentUser(String appId, String env, String namespaceName) {
        if (!this.portalConfig.isConfigViewMemberOnly(env)) {
            return false;
        }
        AppNamespace appNamespace = this.appNamespaceService.findByAppIdAndName(appId, namespaceName);
        if (appNamespace != null && appNamespace.isPublic()) {
            return false;
        }
        return !this.isAppAdmin(appId) && !this.hasOperateNamespacePermission(appId, namespaceName, env);
    }

    public boolean hasCreateApplicationPermission() {
        return this.hasCreateApplicationPermission(this.userInfoHolder.getUser().getUserId());
    }

    public boolean hasCreateApplicationPermission(String userId) {
        return this.systemRoleManagerService.hasCreateApplicationPermission(userId);
    }

    public boolean hasManageAppMasterPermission(String appId) {
        return this.isSuperAdmin() || this.hasAssignRolePermission(appId) && this.systemRoleManagerService.hasManageAppMasterPermission(this.userInfoHolder.getUser().getUserId(), appId);
    }
}

