/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.component;

import com.ctrip.framework.apollo.common.dto.ItemChangeSets;
import com.ctrip.framework.apollo.common.dto.ItemDTO;
import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ItemsComparator {
    public ItemChangeSets compareIgnoreBlankAndCommentItem(long baseNamespaceId, List<ItemDTO> baseItems, List<ItemDTO> targetItems) {
        String key;
        List<ItemDTO> filteredSourceItems = this.filterBlankAndCommentItem(baseItems);
        List<ItemDTO> filteredTargetItems = this.filterBlankAndCommentItem(targetItems);
        Map sourceItemMap = BeanUtils.mapByKey((String)"key", filteredSourceItems);
        Map targetItemMap = BeanUtils.mapByKey((String)"key", filteredTargetItems);
        ItemChangeSets changeSets = new ItemChangeSets();
        for (ItemDTO item : targetItems) {
            key = item.getKey();
            ItemDTO sourceItem = (ItemDTO)sourceItemMap.get(key);
            if (sourceItem == null) {
                ItemDTO copiedItem = this.copyItem(item);
                copiedItem.setNamespaceId(baseNamespaceId);
                changeSets.addCreateItem(copiedItem);
                continue;
            }
            if (Objects.equals(sourceItem.getValue(), item.getValue())) continue;
            sourceItem.setValue(item.getValue());
            sourceItem.setComment(item.getComment());
            changeSets.addUpdateItem(sourceItem);
        }
        for (ItemDTO item : baseItems) {
            key = item.getKey();
            ItemDTO targetItem = (ItemDTO)targetItemMap.get(key);
            if (targetItem != null) continue;
            changeSets.addDeleteItem(item);
        }
        return changeSets;
    }

    private List<ItemDTO> filterBlankAndCommentItem(List<ItemDTO> items) {
        LinkedList<ItemDTO> result = new LinkedList<ItemDTO>();
        if (CollectionUtils.isEmpty(items)) {
            return result;
        }
        for (ItemDTO item : items) {
            if (StringUtils.isEmpty((String)item.getKey())) continue;
            result.add(item);
        }
        return result;
    }

    private ItemDTO copyItem(ItemDTO sourceItem) {
        ItemDTO copiedItem = new ItemDTO();
        copiedItem.setKey(sourceItem.getKey());
        copiedItem.setValue(sourceItem.getValue());
        copiedItem.setComment(sourceItem.getComment());
        return copiedItem;
    }
}

