/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.component;

import com.ctrip.framework.apollo.core.dto.ServiceDTO;
import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.portal.component.PortalSettings;
import com.ctrip.framework.apollo.portal.component.RestTemplateFactory;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.environment.PortalMetaDomainService;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class AdminServiceAddressLocator {
    private static final long NORMAL_REFRESH_INTERVAL = 300000L;
    private static final long OFFLINE_REFRESH_INTERVAL = 10000L;
    private static final int RETRY_TIMES = 3;
    private static final String ADMIN_SERVICE_URL_PATH = "/services/admin";
    private static final Logger logger = LoggerFactory.getLogger(AdminServiceAddressLocator.class);
    private ScheduledExecutorService refreshServiceAddressService;
    private RestTemplate restTemplate;
    private List<Env> allEnvs;
    private Map<Env, List<ServiceDTO>> cache = new ConcurrentHashMap<Env, List<ServiceDTO>>();
    private final PortalSettings portalSettings;
    private final RestTemplateFactory restTemplateFactory;
    private final PortalMetaDomainService portalMetaDomainService;

    public AdminServiceAddressLocator(HttpMessageConverters httpMessageConverters, PortalSettings portalSettings, RestTemplateFactory restTemplateFactory, PortalMetaDomainService portalMetaDomainService) {
        this.portalSettings = portalSettings;
        this.restTemplateFactory = restTemplateFactory;
        this.portalMetaDomainService = portalMetaDomainService;
    }

    @PostConstruct
    public void init() {
        this.allEnvs = this.portalSettings.getAllEnvs();
        this.restTemplate = this.restTemplateFactory.getObject();
        this.refreshServiceAddressService = Executors.newScheduledThreadPool(1, ApolloThreadFactory.create((String)"ServiceLocator", (boolean)true));
        this.refreshServiceAddressService.schedule(new RefreshAdminServerAddressTask(), 1L, TimeUnit.MILLISECONDS);
    }

    public List<ServiceDTO> getServiceList(Env env) {
        List<ServiceDTO> services = this.cache.get(env);
        if (CollectionUtils.isEmpty(services)) {
            return Collections.emptyList();
        }
        ArrayList randomConfigServices = Lists.newArrayList(services);
        Collections.shuffle(randomConfigServices);
        return randomConfigServices;
    }

    private boolean refreshServerAddressCache(Env env) {
        for (int i = 0; i < 3; ++i) {
            try {
                ServiceDTO[] services = this.getAdminServerAddress(env);
                if (services == null || services.length == 0) continue;
                this.cache.put(env, Arrays.asList(services));
                return true;
            }
            catch (Throwable e) {
                logger.error(String.format("Get admin server address from meta server failed. env: %s, meta server address:%s", env, this.portalMetaDomainService.getDomain(env)), e);
                Tracer.logError((String)String.format("Get admin server address from meta server failed. env: %s, meta server address:%s", env, this.portalMetaDomainService.getDomain(env)), (Throwable)e);
            }
        }
        return false;
    }

    private ServiceDTO[] getAdminServerAddress(Env env) {
        String domainName = this.portalMetaDomainService.getDomain(env);
        String url = domainName + ADMIN_SERVICE_URL_PATH;
        return (ServiceDTO[])this.restTemplate.getForObject(url, ServiceDTO[].class, new Object[0]);
    }

    private class RefreshAdminServerAddressTask
    implements Runnable {
        private RefreshAdminServerAddressTask() {
        }

        @Override
        public void run() {
            boolean refreshSuccess = true;
            for (Env env : AdminServiceAddressLocator.this.allEnvs) {
                boolean currentEnvRefreshResult = AdminServiceAddressLocator.this.refreshServerAddressCache(env);
                refreshSuccess = refreshSuccess && currentEnvRefreshResult;
            }
            if (refreshSuccess) {
                AdminServiceAddressLocator.this.refreshServiceAddressService.schedule(new RefreshAdminServerAddressTask(), 300000L, TimeUnit.MILLISECONDS);
            } else {
                AdminServiceAddressLocator.this.refreshServiceAddressService.schedule(new RefreshAdminServerAddressTask(), 10000L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

