/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.portal.api;

import com.ctrip.framework.apollo.common.dto.AccessKeyDTO;
import com.ctrip.framework.apollo.common.dto.AppDTO;
import com.ctrip.framework.apollo.common.dto.AppNamespaceDTO;
import com.ctrip.framework.apollo.common.dto.ClusterDTO;
import com.ctrip.framework.apollo.common.dto.CommitDTO;
import com.ctrip.framework.apollo.common.dto.GrayReleaseRuleDTO;
import com.ctrip.framework.apollo.common.dto.InstanceDTO;
import com.ctrip.framework.apollo.common.dto.ItemChangeSets;
import com.ctrip.framework.apollo.common.dto.ItemDTO;
import com.ctrip.framework.apollo.common.dto.NamespaceDTO;
import com.ctrip.framework.apollo.common.dto.NamespaceLockDTO;
import com.ctrip.framework.apollo.common.dto.PageDTO;
import com.ctrip.framework.apollo.common.dto.ReleaseDTO;
import com.ctrip.framework.apollo.common.dto.ReleaseHistoryDTO;
import com.ctrip.framework.apollo.portal.api.API;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.health.Health;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class AdminServiceAPI {

    @Service
    public static class ReleaseHistoryAPI
    extends API {
        private ParameterizedTypeReference<PageDTO<ReleaseHistoryDTO>> type = new ParameterizedTypeReference<PageDTO<ReleaseHistoryDTO>>(){};

        public PageDTO<ReleaseHistoryDTO> findReleaseHistoriesByNamespace(String appId, Env env, String clusterName, String namespaceName, int page, int size) {
            return (PageDTO)this.restTemplate.get(env, "/apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/releases/histories?page={page}&size={size}", this.type, appId, clusterName, namespaceName, page, size).getBody();
        }

        public PageDTO<ReleaseHistoryDTO> findByReleaseIdAndOperation(Env env, long releaseId, int operation, int page, int size) {
            return (PageDTO)this.restTemplate.get(env, "/releases/histories/by_release_id_and_operation?releaseId={releaseId}&operation={operation}&page={page}&size={size}", this.type, releaseId, operation, page, size).getBody();
        }

        public PageDTO<ReleaseHistoryDTO> findByPreviousReleaseIdAndOperation(Env env, long previousReleaseId, int operation, int page, int size) {
            return (PageDTO)this.restTemplate.get(env, "/releases/histories/by_previous_release_id_and_operation?previousReleaseId={releaseId}&operation={operation}&page={page}&size={size}", this.type, previousReleaseId, operation, page, size).getBody();
        }
    }

    @Service
    public static class NamespaceBranchAPI
    extends API {
        public NamespaceDTO createBranch(String appId, Env env, String clusterName, String namespaceName, String operator) {
            return this.restTemplate.post(env, "/apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/branches?operator={operator}", null, NamespaceDTO.class, appId, clusterName, namespaceName, operator);
        }

        public NamespaceDTO findBranch(String appId, Env env, String clusterName, String namespaceName) {
            return this.restTemplate.get(env, "/apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/branches", NamespaceDTO.class, appId, clusterName, namespaceName);
        }

        public GrayReleaseRuleDTO findBranchGrayRules(String appId, Env env, String clusterName, String namespaceName, String branchName) {
            return this.restTemplate.get(env, "/apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/branches/{branchName}/rules", GrayReleaseRuleDTO.class, appId, clusterName, namespaceName, branchName);
        }

        public void updateBranchGrayRules(String appId, Env env, String clusterName, String namespaceName, String branchName, GrayReleaseRuleDTO rules) {
            this.restTemplate.put(env, "/apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/branches/{branchName}/rules", rules, appId, clusterName, namespaceName, branchName);
        }

        public void deleteBranch(String appId, Env env, String clusterName, String namespaceName, String branchName, String operator) {
            this.restTemplate.delete(env, "/apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/branches/{branchName}?operator={operator}", appId, clusterName, namespaceName, branchName, operator);
        }
    }

    @Service
    public static class InstanceAPI
    extends API {
        private Joiner joiner = Joiner.on((String)",");
        private ParameterizedTypeReference<PageDTO<InstanceDTO>> pageInstanceDtoType = new ParameterizedTypeReference<PageDTO<InstanceDTO>>(){};

        public PageDTO<InstanceDTO> getByRelease(Env env, long releaseId, int page, int size) {
            ResponseEntity<PageDTO<InstanceDTO>> entity = this.restTemplate.get(env, "/instances/by-release?releaseId={releaseId}&page={page}&size={size}", this.pageInstanceDtoType, releaseId, page, size);
            return (PageDTO)entity.getBody();
        }

        public List<InstanceDTO> getByReleasesNotIn(String appId, Env env, String clusterName, String namespaceName, Set<Long> releaseIds) {
            InstanceDTO[] instanceDTOs = this.restTemplate.get(env, "/instances/by-namespace-and-releases-not-in?appId={appId}&clusterName={clusterName}&namespaceName={namespaceName}&releaseIds={releaseIds}", InstanceDTO[].class, appId, clusterName, namespaceName, this.joiner.join(releaseIds));
            return Arrays.asList(instanceDTOs);
        }

        public PageDTO<InstanceDTO> getByNamespace(String appId, Env env, String clusterName, String namespaceName, String instanceAppId, int page, int size) {
            ResponseEntity<PageDTO<InstanceDTO>> entity = this.restTemplate.get(env, "/instances/by-namespace?appId={appId}&clusterName={clusterName}&namespaceName={namespaceName}&instanceAppId={instanceAppId}&page={page}&size={size}", this.pageInstanceDtoType, appId, clusterName, namespaceName, instanceAppId, page, size);
            return (PageDTO)entity.getBody();
        }

        public int getInstanceCountByNamespace(String appId, Env env, String clusterName, String namespaceName) {
            Integer count = this.restTemplate.get(env, "/instances/by-namespace/count?appId={appId}&clusterName={clusterName}&namespaceName={namespaceName}", Integer.class, appId, clusterName, namespaceName);
            if (count == null) {
                return 0;
            }
            return count;
        }
    }

    @Service
    public static class NamespaceLockAPI
    extends API {
        public NamespaceLockDTO getNamespaceLockOwner(String appId, Env env, String clusterName, String namespaceName) {
            return this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/lock", NamespaceLockDTO.class, appId, clusterName, namespaceName);
        }
    }

    @Service
    public static class CommitAPI
    extends API {
        public List<CommitDTO> find(String appId, Env env, String clusterName, String namespaceName, int page, int size) {
            CommitDTO[] commitDTOs = this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/commit?page={page}&size={size}", CommitDTO[].class, appId, clusterName, namespaceName, page, size);
            return Arrays.asList(commitDTOs);
        }
    }

    @Service
    public static class ReleaseAPI
    extends API {
        private static final Joiner JOINER = Joiner.on((String)",");

        public ReleaseDTO loadRelease(Env env, long releaseId) {
            return this.restTemplate.get(env, "releases/{releaseId}", ReleaseDTO.class, releaseId);
        }

        public List<ReleaseDTO> findReleaseByIds(Env env, Set<Long> releaseIds) {
            if (CollectionUtils.isEmpty(releaseIds)) {
                return Collections.emptyList();
            }
            ReleaseDTO[] releases = this.restTemplate.get(env, "/releases?releaseIds={releaseIds}", ReleaseDTO[].class, JOINER.join(releaseIds));
            return Arrays.asList(releases);
        }

        public List<ReleaseDTO> findAllReleases(String appId, Env env, String clusterName, String namespaceName, int page, int size) {
            ReleaseDTO[] releaseDTOs = this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/releases/all?page={page}&size={size}", ReleaseDTO[].class, appId, clusterName, namespaceName, page, size);
            return Arrays.asList(releaseDTOs);
        }

        public List<ReleaseDTO> findActiveReleases(String appId, Env env, String clusterName, String namespaceName, int page, int size) {
            ReleaseDTO[] releaseDTOs = this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/releases/active?page={page}&size={size}", ReleaseDTO[].class, appId, clusterName, namespaceName, page, size);
            return Arrays.asList(releaseDTOs);
        }

        public ReleaseDTO loadLatestRelease(String appId, Env env, String clusterName, String namespace) {
            ReleaseDTO releaseDTO = this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/releases/latest", ReleaseDTO.class, appId, clusterName, namespace);
            return releaseDTO;
        }

        public ReleaseDTO createRelease(String appId, Env env, String clusterName, String namespace, String releaseName, String releaseComment, String operator, boolean isEmergencyPublish) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/x-www-form-urlencoded;charset=UTF-8"));
            LinkedMultiValueMap parameters = new LinkedMultiValueMap();
            parameters.add((Object)"name", (Object)releaseName);
            parameters.add((Object)"comment", (Object)releaseComment);
            parameters.add((Object)"operator", (Object)operator);
            parameters.add((Object)"isEmergencyPublish", (Object)String.valueOf(isEmergencyPublish));
            HttpEntity entity = new HttpEntity((Object)parameters, (MultiValueMap)headers);
            ReleaseDTO response = this.restTemplate.post(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/releases", entity, ReleaseDTO.class, appId, clusterName, namespace);
            return response;
        }

        public ReleaseDTO createGrayDeletionRelease(String appId, Env env, String clusterName, String namespace, String releaseName, String releaseComment, String operator, boolean isEmergencyPublish, Set<String> grayDelKeys) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/x-www-form-urlencoded;charset=UTF-8"));
            LinkedMultiValueMap parameters = new LinkedMultiValueMap();
            parameters.add((Object)"releaseName", (Object)releaseName);
            parameters.add((Object)"comment", (Object)releaseComment);
            parameters.add((Object)"operator", (Object)operator);
            parameters.add((Object)"isEmergencyPublish", (Object)String.valueOf(isEmergencyPublish));
            grayDelKeys.forEach(arg_0 -> ReleaseAPI.lambda$createGrayDeletionRelease$0((MultiValueMap)parameters, arg_0));
            HttpEntity entity = new HttpEntity((Object)parameters, (MultiValueMap)headers);
            ReleaseDTO response = this.restTemplate.post(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/gray-del-releases", entity, ReleaseDTO.class, appId, clusterName, namespace);
            return response;
        }

        public ReleaseDTO updateAndPublish(String appId, Env env, String clusterName, String namespace, String releaseName, String releaseComment, String branchName, boolean isEmergencyPublish, boolean deleteBranch, ItemChangeSets changeSets) {
            return this.restTemplate.post(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/updateAndPublish?releaseName={releaseName}&releaseComment={releaseComment}&branchName={branchName}&deleteBranch={deleteBranch}&isEmergencyPublish={isEmergencyPublish}", changeSets, ReleaseDTO.class, appId, clusterName, namespace, releaseName, releaseComment, branchName, deleteBranch, isEmergencyPublish);
        }

        public void rollback(Env env, long releaseId, String operator) {
            this.restTemplate.put(env, "releases/{releaseId}/rollback?operator={operator}", null, releaseId, operator);
        }

        public void rollbackTo(Env env, long releaseId, long toReleaseId, String operator) {
            this.restTemplate.put(env, "releases/{releaseId}/rollback?toReleaseId={toReleaseId}&operator={operator}", null, releaseId, toReleaseId, operator);
        }

        private static /* synthetic */ void lambda$createGrayDeletionRelease$0(MultiValueMap parameters, String key) {
            parameters.add((Object)"grayDelKeys", (Object)key);
        }
    }

    @Service
    public static class AccessKeyAPI
    extends API {
        public AccessKeyDTO create(Env env, AccessKeyDTO accessKey) {
            return this.restTemplate.post(env, "apps/{appId}/accesskeys", accessKey, AccessKeyDTO.class, accessKey.getAppId());
        }

        public List<AccessKeyDTO> findByAppId(Env env, String appId) {
            AccessKeyDTO[] accessKeys = this.restTemplate.get(env, "apps/{appId}/accesskeys", AccessKeyDTO[].class, appId);
            return Arrays.asList(accessKeys);
        }

        public void delete(Env env, String appId, long id, String operator) {
            this.restTemplate.delete(env, "apps/{appId}/accesskeys/{id}?operator={operator}", appId, id, operator);
        }

        public void enable(Env env, String appId, long id, String operator) {
            this.restTemplate.put(env, "apps/{appId}/accesskeys/{id}/enable?operator={operator}", null, appId, id, operator);
        }

        public void disable(Env env, String appId, long id, String operator) {
            this.restTemplate.put(env, "apps/{appId}/accesskeys/{id}/disable?operator={operator}", null, appId, id, operator);
        }
    }

    @Service
    public static class ClusterAPI
    extends API {
        public List<ClusterDTO> findClustersByApp(String appId, Env env) {
            ClusterDTO[] clusterDTOs = this.restTemplate.get(env, "apps/{appId}/clusters", ClusterDTO[].class, appId);
            return Arrays.asList(clusterDTOs);
        }

        public ClusterDTO loadCluster(String appId, Env env, String clusterName) {
            return this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}", ClusterDTO.class, appId, clusterName);
        }

        public boolean isClusterUnique(String appId, Env env, String clusterName) {
            return this.restTemplate.get(env, "apps/{appId}/cluster/{clusterName}/unique", Boolean.class, appId, clusterName);
        }

        public ClusterDTO create(Env env, ClusterDTO cluster) {
            return this.restTemplate.post(env, "apps/{appId}/clusters", cluster, ClusterDTO.class, cluster.getAppId());
        }

        public void delete(Env env, String appId, String clusterName, String operator) {
            this.restTemplate.delete(env, "apps/{appId}/clusters/{clusterName}?operator={operator}", appId, clusterName, operator);
        }
    }

    @Service
    public static class ItemAPI
    extends API {
        public List<ItemDTO> findItems(String appId, Env env, String clusterName, String namespaceName) {
            ItemDTO[] itemDTOs = this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/items", ItemDTO[].class, appId, clusterName, namespaceName);
            return Arrays.asList(itemDTOs);
        }

        public List<ItemDTO> findDeletedItems(String appId, Env env, String clusterName, String namespaceName) {
            ItemDTO[] itemDTOs = this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/items/deleted", ItemDTO[].class, appId, clusterName, namespaceName);
            return Arrays.asList(itemDTOs);
        }

        public ItemDTO loadItem(Env env, String appId, String clusterName, String namespaceName, String key) {
            return this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/items/{key}", ItemDTO.class, appId, clusterName, namespaceName, key);
        }

        public ItemDTO loadItemById(Env env, long itemId) {
            return this.restTemplate.get(env, "items/{itemId}", ItemDTO.class, itemId);
        }

        public void updateItemsByChangeSet(String appId, Env env, String clusterName, String namespace, ItemChangeSets changeSets) {
            this.restTemplate.post(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/itemset", changeSets, Void.class, appId, clusterName, namespace);
        }

        public void updateItem(String appId, Env env, String clusterName, String namespace, long itemId, ItemDTO item) {
            this.restTemplate.put(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/items/{itemId}", item, appId, clusterName, namespace, itemId);
        }

        public ItemDTO createItem(String appId, Env env, String clusterName, String namespace, ItemDTO item) {
            return this.restTemplate.post(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/items", item, ItemDTO.class, appId, clusterName, namespace);
        }

        public void deleteItem(Env env, long itemId, String operator) {
            this.restTemplate.delete(env, "items/{itemId}?operator={operator}", itemId, operator);
        }
    }

    @Service
    public static class NamespaceAPI
    extends API {
        private ParameterizedTypeReference<Map<String, Boolean>> typeReference = new ParameterizedTypeReference<Map<String, Boolean>>(){};

        public List<NamespaceDTO> findNamespaceByCluster(String appId, Env env, String clusterName) {
            NamespaceDTO[] namespaceDTOs = this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}/namespaces", NamespaceDTO[].class, appId, clusterName);
            return Arrays.asList(namespaceDTOs);
        }

        public NamespaceDTO loadNamespace(String appId, Env env, String clusterName, String namespaceName) {
            return this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}", NamespaceDTO.class, appId, clusterName, namespaceName);
        }

        public NamespaceDTO findPublicNamespaceForAssociatedNamespace(Env env, String appId, String clusterName, String namespaceName) {
            return this.restTemplate.get(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/associated-public-namespace", NamespaceDTO.class, appId, clusterName, namespaceName);
        }

        public NamespaceDTO createNamespace(Env env, NamespaceDTO namespace) {
            return this.restTemplate.post(env, "apps/{appId}/clusters/{clusterName}/namespaces", namespace, NamespaceDTO.class, namespace.getAppId(), namespace.getClusterName());
        }

        public AppNamespaceDTO createAppNamespace(Env env, AppNamespaceDTO appNamespace) {
            return this.restTemplate.post(env, "apps/{appId}/appnamespaces", appNamespace, AppNamespaceDTO.class, appNamespace.getAppId());
        }

        public AppNamespaceDTO createMissingAppNamespace(Env env, AppNamespaceDTO appNamespace) {
            return this.restTemplate.post(env, "apps/{appId}/appnamespaces?silentCreation=true", appNamespace, AppNamespaceDTO.class, appNamespace.getAppId());
        }

        public List<AppNamespaceDTO> getAppNamespaces(String appId, Env env) {
            AppNamespaceDTO[] appNamespaceDTOs = this.restTemplate.get(env, "apps/{appId}/appnamespaces", AppNamespaceDTO[].class, appId);
            return Arrays.asList(appNamespaceDTOs);
        }

        public void deleteNamespace(Env env, String appId, String clusterName, String namespaceName, String operator) {
            this.restTemplate.delete(env, "apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}?operator={operator}", appId, clusterName, namespaceName, operator);
        }

        public Map<String, Boolean> getNamespacePublishInfo(Env env, String appId) {
            return (Map)this.restTemplate.get(env, "apps/{appId}/namespaces/publish_info", this.typeReference, appId).getBody();
        }

        public List<NamespaceDTO> getPublicAppNamespaceAllNamespaces(Env env, String publicNamespaceName, int page, int size) {
            NamespaceDTO[] namespaceDTOs = this.restTemplate.get(env, "/appnamespaces/{publicNamespaceName}/namespaces?page={page}&size={size}", NamespaceDTO[].class, publicNamespaceName, page, size);
            return Arrays.asList(namespaceDTOs);
        }

        public int countPublicAppNamespaceAssociatedNamespaces(Env env, String publicNamesapceName) {
            Integer count = this.restTemplate.get(env, "/appnamespaces/{publicNamespaceName}/associated-namespaces/count", Integer.class, publicNamesapceName);
            return count == null ? 0 : count;
        }

        public void deleteAppNamespace(Env env, String appId, String namespaceName, String operator) {
            this.restTemplate.delete(env, "/apps/{appId}/appnamespaces/{namespaceName}?operator={operator}", appId, namespaceName, operator);
        }
    }

    @Service
    public static class AppAPI
    extends API {
        public AppDTO loadApp(Env env, String appId) {
            return this.restTemplate.get(env, "apps/{appId}", AppDTO.class, appId);
        }

        public AppDTO createApp(Env env, AppDTO app) {
            return this.restTemplate.post(env, "apps", app, AppDTO.class, new Object[0]);
        }

        public void updateApp(Env env, AppDTO app) {
            this.restTemplate.put(env, "apps/{appId}", app, app.getAppId());
        }

        public void deleteApp(Env env, String appId, String operator) {
            this.restTemplate.delete(env, "/apps/{appId}?operator={operator}", appId, operator);
        }
    }

    @Service
    public static class HealthAPI
    extends API {
        public Health health(Env env) {
            return this.restTemplate.get(env, "/health", Health.class, new Object[0]);
        }
    }
}

