/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.v1.controller;

import com.ctrip.framework.apollo.common.dto.ItemDTO;
import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.common.utils.RequestPrecondition;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.openapi.dto.OpenItemDTO;
import com.ctrip.framework.apollo.openapi.util.OpenApiBeanUtils;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.ItemService;
import com.ctrip.framework.apollo.portal.spi.UserService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpStatusCodeException;

@RestController(value="openapiItemController")
@RequestMapping(value={"/openapi/v1/envs/{env}"})
public class ItemController {
    private final ItemService itemService;
    private final UserService userService;

    public ItemController(ItemService itemService, UserService userService) {
        this.itemService = itemService;
        this.userService = userService;
    }

    @GetMapping(value={"/apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/items/{key:.+}"})
    public OpenItemDTO getItem(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, @PathVariable String key) {
        ItemDTO itemDTO = this.itemService.loadItem(Env.fromString(env), appId, clusterName, namespaceName, key);
        return itemDTO == null ? null : OpenApiBeanUtils.transformFromItemDTO(itemDTO);
    }

    @PreAuthorize(value="@consumerPermissionValidator.hasModifyNamespacePermission(#request, #appId, #namespaceName, #env)")
    @PostMapping(value={"/apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/items"})
    public OpenItemDTO createItem(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, @RequestBody OpenItemDTO item, HttpServletRequest request) {
        RequestPrecondition.checkArguments((!StringUtils.isContainEmpty((String[])new String[]{item.getKey(), item.getDataChangeCreatedBy()}) ? 1 : 0) != 0, (Object)"key and dataChangeCreatedBy should not be null or empty");
        if (this.userService.findByUserId(item.getDataChangeCreatedBy()) == null) {
            throw new BadRequestException("User " + item.getDataChangeCreatedBy() + " doesn't exist!");
        }
        if (!StringUtils.isEmpty((String)item.getComment()) && item.getComment().length() > 64) {
            throw new BadRequestException("Comment length should not exceed 64 characters");
        }
        ItemDTO toCreate = OpenApiBeanUtils.transformToItemDTO(item);
        toCreate.setLineNum(0);
        toCreate.setId(0L);
        toCreate.setDataChangeLastModifiedBy(toCreate.getDataChangeCreatedBy());
        toCreate.setDataChangeLastModifiedTime(null);
        toCreate.setDataChangeCreatedTime(null);
        ItemDTO createdItem = this.itemService.createItem(appId, Env.fromString(env), clusterName, namespaceName, toCreate);
        return OpenApiBeanUtils.transformFromItemDTO(createdItem);
    }

    @PreAuthorize(value="@consumerPermissionValidator.hasModifyNamespacePermission(#request, #appId, #namespaceName, #env)")
    @PutMapping(value={"/apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/items/{key:.+}"})
    public void updateItem(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, @PathVariable String key, @RequestBody OpenItemDTO item, @RequestParam(defaultValue="false") boolean createIfNotExists, HttpServletRequest request) {
        RequestPrecondition.checkArguments((item != null ? 1 : 0) != 0, (Object)"item payload can not be empty");
        RequestPrecondition.checkArguments((!StringUtils.isContainEmpty((String[])new String[]{item.getKey(), item.getDataChangeLastModifiedBy()}) ? 1 : 0) != 0, (Object)"key and dataChangeLastModifiedBy can not be empty");
        RequestPrecondition.checkArguments((boolean)item.getKey().equals(key), (Object)"Key in path and payload is not consistent");
        if (this.userService.findByUserId(item.getDataChangeLastModifiedBy()) == null) {
            throw new BadRequestException("user(dataChangeLastModifiedBy) not exists");
        }
        if (!StringUtils.isEmpty((String)item.getComment()) && item.getComment().length() > 64) {
            throw new BadRequestException("Comment length should not exceed 64 characters");
        }
        try {
            ItemDTO toUpdateItem = this.itemService.loadItem(Env.fromString(env), appId, clusterName, namespaceName, item.getKey());
            toUpdateItem.setComment(item.getComment());
            toUpdateItem.setValue(item.getValue());
            toUpdateItem.setDataChangeLastModifiedBy(item.getDataChangeLastModifiedBy());
            this.itemService.updateItem(appId, Env.fromString(env), clusterName, namespaceName, toUpdateItem);
        }
        catch (Throwable ex) {
            if (ex instanceof HttpStatusCodeException && ((HttpStatusCodeException)ex).getStatusCode().equals((Object)HttpStatus.NOT_FOUND) && createIfNotExists) {
                this.createItem(appId, env, clusterName, namespaceName, item, request);
                return;
            }
            throw ex;
        }
    }

    @PreAuthorize(value="@consumerPermissionValidator.hasModifyNamespacePermission(#request, #appId, #namespaceName, #env)")
    @DeleteMapping(value={"/apps/{appId}/clusters/{clusterName}/namespaces/{namespaceName}/items/{key:.+}"})
    public void deleteItem(@PathVariable String appId, @PathVariable String env, @PathVariable String clusterName, @PathVariable String namespaceName, @PathVariable String key, @RequestParam String operator, HttpServletRequest request) {
        if (this.userService.findByUserId(operator) == null) {
            throw new BadRequestException("user(operator) not exists");
        }
        ItemDTO toDeleteItem = this.itemService.loadItem(Env.fromString(env), appId, clusterName, namespaceName, key);
        if (toDeleteItem == null) {
            throw new BadRequestException("item not exists");
        }
        this.itemService.deleteItem(Env.fromString(env), toDeleteItem.getId(), operator);
    }
}

