/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.v1.controller;

import com.ctrip.framework.apollo.common.dto.ClusterDTO;
import com.ctrip.framework.apollo.common.entity.App;
import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.openapi.dto.OpenAppDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenEnvClusterDTO;
import com.ctrip.framework.apollo.openapi.util.OpenApiBeanUtils;
import com.ctrip.framework.apollo.portal.component.PortalSettings;
import com.ctrip.framework.apollo.portal.environment.Env;
import com.ctrip.framework.apollo.portal.service.AppService;
import com.ctrip.framework.apollo.portal.service.ClusterService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="openapiAppController")
@RequestMapping(value={"/openapi/v1"})
public class AppController {
    private final PortalSettings portalSettings;
    private final ClusterService clusterService;
    private final AppService appService;

    public AppController(PortalSettings portalSettings, ClusterService clusterService, AppService appService) {
        this.portalSettings = portalSettings;
        this.clusterService = clusterService;
        this.appService = appService;
    }

    @GetMapping(value={"/apps/{appId}/envclusters"})
    public List<OpenEnvClusterDTO> loadEnvClusterInfo(@PathVariable String appId) {
        LinkedList<OpenEnvClusterDTO> envClusters = new LinkedList<OpenEnvClusterDTO>();
        List<Env> envs = this.portalSettings.getActiveEnvs();
        for (Env env : envs) {
            OpenEnvClusterDTO envCluster = new OpenEnvClusterDTO();
            envCluster.setEnv(env.name());
            List<ClusterDTO> clusterDTOs = this.clusterService.findClusters(env, appId);
            envCluster.setClusters(BeanUtils.toPropertySet((String)"name", clusterDTOs));
            envClusters.add(envCluster);
        }
        return envClusters;
    }

    @GetMapping(value={"/apps"})
    public List<OpenAppDTO> findApps(@RequestParam(value="appIds", required=false) String appIds) {
        ArrayList<App> apps = new ArrayList<App>();
        if (StringUtils.isEmpty((Object)appIds)) {
            apps.addAll(this.appService.findAll());
        } else {
            apps.addAll(this.appService.findByAppIds(Sets.newHashSet((Object[])appIds.split(","))));
        }
        return OpenApiBeanUtils.transformFromApps(apps);
    }
}

