/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.util;

import com.ctrip.framework.apollo.common.dto.ClusterDTO;
import com.ctrip.framework.apollo.common.dto.GrayReleaseRuleDTO;
import com.ctrip.framework.apollo.common.dto.GrayReleaseRuleItemDTO;
import com.ctrip.framework.apollo.common.dto.ItemDTO;
import com.ctrip.framework.apollo.common.dto.NamespaceLockDTO;
import com.ctrip.framework.apollo.common.dto.ReleaseDTO;
import com.ctrip.framework.apollo.common.entity.App;
import com.ctrip.framework.apollo.common.entity.AppNamespace;
import com.ctrip.framework.apollo.common.utils.BeanUtils;
import com.ctrip.framework.apollo.openapi.dto.OpenAppDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenAppNamespaceDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenClusterDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenGrayReleaseRuleDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenItemDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenNamespaceDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenNamespaceLockDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenReleaseDTO;
import com.ctrip.framework.apollo.portal.entity.bo.ItemBO;
import com.ctrip.framework.apollo.portal.entity.bo.NamespaceBO;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class OpenApiBeanUtils {
    private static Gson gson = new Gson();
    private static Type type = new TypeToken<Map<String, String>>(){}.getType();

    public static OpenItemDTO transformFromItemDTO(ItemDTO item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0);
        return (OpenItemDTO)BeanUtils.transform(OpenItemDTO.class, (Object)item);
    }

    public static ItemDTO transformToItemDTO(OpenItemDTO openItemDTO) {
        Preconditions.checkArgument((openItemDTO != null ? 1 : 0) != 0);
        return (ItemDTO)BeanUtils.transform(ItemDTO.class, (Object)openItemDTO);
    }

    public static OpenAppNamespaceDTO transformToOpenAppNamespaceDTO(AppNamespace appNamespace) {
        Preconditions.checkArgument((appNamespace != null ? 1 : 0) != 0);
        return (OpenAppNamespaceDTO)BeanUtils.transform(OpenAppNamespaceDTO.class, (Object)appNamespace);
    }

    public static AppNamespace transformToAppNamespace(OpenAppNamespaceDTO openAppNamespaceDTO) {
        Preconditions.checkArgument((openAppNamespaceDTO != null ? 1 : 0) != 0);
        return (AppNamespace)BeanUtils.transform(AppNamespace.class, (Object)openAppNamespaceDTO);
    }

    public static OpenReleaseDTO transformFromReleaseDTO(ReleaseDTO release) {
        Preconditions.checkArgument((release != null ? 1 : 0) != 0);
        OpenReleaseDTO openReleaseDTO = (OpenReleaseDTO)BeanUtils.transform(OpenReleaseDTO.class, (Object)release);
        Map configs = (Map)gson.fromJson(release.getConfigurations(), type);
        openReleaseDTO.setConfigurations(configs);
        return openReleaseDTO;
    }

    public static OpenNamespaceDTO transformFromNamespaceBO(NamespaceBO namespaceBO) {
        Preconditions.checkArgument((namespaceBO != null ? 1 : 0) != 0);
        OpenNamespaceDTO openNamespaceDTO = (OpenNamespaceDTO)BeanUtils.transform(OpenNamespaceDTO.class, (Object)namespaceBO.getBaseInfo());
        openNamespaceDTO.setFormat(namespaceBO.getFormat());
        openNamespaceDTO.setComment(namespaceBO.getComment());
        openNamespaceDTO.setPublic(namespaceBO.isPublic());
        LinkedList items = new LinkedList();
        List<ItemBO> itemBOs = namespaceBO.getItems();
        if (!CollectionUtils.isEmpty(itemBOs)) {
            items.addAll(itemBOs.stream().map(itemBO -> OpenApiBeanUtils.transformFromItemDTO(itemBO.getItem())).collect(Collectors.toList()));
        }
        openNamespaceDTO.setItems(items);
        return openNamespaceDTO;
    }

    public static List<OpenNamespaceDTO> batchTransformFromNamespaceBOs(List<NamespaceBO> namespaceBOs) {
        if (CollectionUtils.isEmpty(namespaceBOs)) {
            return Collections.emptyList();
        }
        List openNamespaceDTOs = namespaceBOs.stream().map(OpenApiBeanUtils::transformFromNamespaceBO).collect(Collectors.toCollection(LinkedList::new));
        return openNamespaceDTOs;
    }

    public static OpenNamespaceLockDTO transformFromNamespaceLockDTO(String namespaceName, NamespaceLockDTO namespaceLock) {
        OpenNamespaceLockDTO lock = new OpenNamespaceLockDTO();
        lock.setNamespaceName(namespaceName);
        if (namespaceLock == null) {
            lock.setLocked(false);
        } else {
            lock.setLocked(true);
            lock.setLockedBy(namespaceLock.getDataChangeCreatedBy());
        }
        return lock;
    }

    public static OpenGrayReleaseRuleDTO transformFromGrayReleaseRuleDTO(GrayReleaseRuleDTO grayReleaseRuleDTO) {
        Preconditions.checkArgument((grayReleaseRuleDTO != null ? 1 : 0) != 0);
        return (OpenGrayReleaseRuleDTO)BeanUtils.transform(OpenGrayReleaseRuleDTO.class, (Object)grayReleaseRuleDTO);
    }

    public static GrayReleaseRuleDTO transformToGrayReleaseRuleDTO(OpenGrayReleaseRuleDTO openGrayReleaseRuleDTO) {
        Preconditions.checkArgument((openGrayReleaseRuleDTO != null ? 1 : 0) != 0);
        String appId = openGrayReleaseRuleDTO.getAppId();
        String branchName = openGrayReleaseRuleDTO.getBranchName();
        String clusterName = openGrayReleaseRuleDTO.getClusterName();
        String namespaceName = openGrayReleaseRuleDTO.getNamespaceName();
        GrayReleaseRuleDTO grayReleaseRuleDTO = new GrayReleaseRuleDTO(appId, clusterName, namespaceName, branchName);
        Set openGrayReleaseRuleItemDTOSet = openGrayReleaseRuleDTO.getRuleItems();
        openGrayReleaseRuleItemDTOSet.forEach(openGrayReleaseRuleItemDTO -> {
            String clientAppId = openGrayReleaseRuleItemDTO.getClientAppId();
            Set clientIpList = openGrayReleaseRuleItemDTO.getClientIpList();
            GrayReleaseRuleItemDTO ruleItem = new GrayReleaseRuleItemDTO(clientAppId, clientIpList);
            grayReleaseRuleDTO.addRuleItem(ruleItem);
        });
        return grayReleaseRuleDTO;
    }

    public static List<OpenAppDTO> transformFromApps(List<App> apps) {
        if (CollectionUtils.isEmpty(apps)) {
            return Collections.emptyList();
        }
        return apps.stream().map(OpenApiBeanUtils::transformFromApp).collect(Collectors.toList());
    }

    public static OpenAppDTO transformFromApp(App app) {
        Preconditions.checkArgument((app != null ? 1 : 0) != 0);
        return (OpenAppDTO)BeanUtils.transform(OpenAppDTO.class, (Object)app);
    }

    public static OpenClusterDTO transformFromClusterDTO(ClusterDTO Cluster) {
        Preconditions.checkArgument((Cluster != null ? 1 : 0) != 0);
        return (OpenClusterDTO)BeanUtils.transform(OpenClusterDTO.class, (Object)Cluster);
    }

    public static ClusterDTO transformToClusterDTO(OpenClusterDTO openClusterDTO) {
        Preconditions.checkArgument((openClusterDTO != null ? 1 : 0) != 0);
        return (ClusterDTO)BeanUtils.transform(ClusterDTO.class, (Object)openClusterDTO);
    }
}

