/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.util;

import com.ctrip.framework.apollo.openapi.service.ConsumerService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class ConsumerAuthUtil {
    static final String CONSUMER_ID = "ApolloConsumerId";
    private final ConsumerService consumerService;

    public ConsumerAuthUtil(ConsumerService consumerService) {
        this.consumerService = consumerService;
    }

    public Long getConsumerId(String token) {
        return this.consumerService.getConsumerIdByToken(token);
    }

    public void storeConsumerId(HttpServletRequest request, Long consumerId) {
        request.setAttribute(CONSUMER_ID, (Object)consumerId);
    }

    public long retrieveConsumerId(HttpServletRequest request) {
        Object value = request.getAttribute(CONSUMER_ID);
        try {
            return Long.parseLong(value.toString());
        }
        catch (Throwable ex) {
            throw new IllegalStateException("No consumer id!", ex);
        }
    }
}

