/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.util;

import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.openapi.entity.ConsumerAudit;
import com.ctrip.framework.apollo.openapi.service.ConsumerService;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class ConsumerAuditUtil
implements InitializingBean {
    private static final int CONSUMER_AUDIT_MAX_SIZE = 10000;
    private BlockingQueue<ConsumerAudit> audits = Queues.newLinkedBlockingQueue((int)10000);
    private final ExecutorService auditExecutorService;
    private final AtomicBoolean auditStopped;
    private int BATCH_SIZE = 100;
    private long BATCH_TIMEOUT = 5L;
    private TimeUnit BATCH_TIMEUNIT = TimeUnit.SECONDS;
    private final ConsumerService consumerService;

    public ConsumerAuditUtil(ConsumerService consumerService) {
        this.consumerService = consumerService;
        this.auditExecutorService = Executors.newSingleThreadExecutor(ApolloThreadFactory.create((String)"ConsumerAuditUtil", (boolean)true));
        this.auditStopped = new AtomicBoolean(false);
    }

    public boolean audit(HttpServletRequest request, long consumerId) {
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            return true;
        }
        String uri = request.getRequestURI();
        if (!Strings.isNullOrEmpty((String)request.getQueryString())) {
            uri = uri + "?" + request.getQueryString();
        }
        ConsumerAudit consumerAudit = new ConsumerAudit();
        Date now = new Date();
        consumerAudit.setConsumerId(consumerId);
        consumerAudit.setUri(uri);
        consumerAudit.setMethod(request.getMethod());
        consumerAudit.setDataChangeCreatedTime(now);
        consumerAudit.setDataChangeLastModifiedTime(now);
        return this.audits.offer(consumerAudit);
    }

    public void afterPropertiesSet() throws Exception {
        this.auditExecutorService.submit(() -> {
            while (!this.auditStopped.get() && !Thread.currentThread().isInterrupted()) {
                ArrayList toAudit = Lists.newArrayList();
                try {
                    Queues.drain(this.audits, (Collection)toAudit, (int)this.BATCH_SIZE, (long)this.BATCH_TIMEOUT, (TimeUnit)this.BATCH_TIMEUNIT);
                    if (toAudit.isEmpty()) continue;
                    this.consumerService.createConsumerAudits(toAudit);
                }
                catch (Throwable ex) {
                    Tracer.logError((Throwable)ex);
                }
            }
        });
    }

    public void stopAudit() {
        this.auditStopped.set(true);
    }
}

