/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.service;

import com.ctrip.framework.apollo.common.exception.BadRequestException;
import com.ctrip.framework.apollo.openapi.entity.Consumer;
import com.ctrip.framework.apollo.openapi.entity.ConsumerAudit;
import com.ctrip.framework.apollo.openapi.entity.ConsumerRole;
import com.ctrip.framework.apollo.openapi.entity.ConsumerToken;
import com.ctrip.framework.apollo.openapi.repository.ConsumerAuditRepository;
import com.ctrip.framework.apollo.openapi.repository.ConsumerRepository;
import com.ctrip.framework.apollo.openapi.repository.ConsumerRoleRepository;
import com.ctrip.framework.apollo.openapi.repository.ConsumerTokenRepository;
import com.ctrip.framework.apollo.portal.component.config.PortalConfig;
import com.ctrip.framework.apollo.portal.entity.bo.UserInfo;
import com.ctrip.framework.apollo.portal.entity.po.Role;
import com.ctrip.framework.apollo.portal.service.RolePermissionService;
import com.ctrip.framework.apollo.portal.spi.UserInfoHolder;
import com.ctrip.framework.apollo.portal.spi.UserService;
import com.ctrip.framework.apollo.portal.util.RoleUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.FastDateFormat;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsumerService {
    private static final FastDateFormat TIMESTAMP_FORMAT = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");
    private static final Joiner KEY_JOINER = Joiner.on((String)"|");
    private final UserInfoHolder userInfoHolder;
    private final ConsumerTokenRepository consumerTokenRepository;
    private final ConsumerRepository consumerRepository;
    private final ConsumerAuditRepository consumerAuditRepository;
    private final ConsumerRoleRepository consumerRoleRepository;
    private final PortalConfig portalConfig;
    private final RolePermissionService rolePermissionService;
    private final UserService userService;

    public ConsumerService(UserInfoHolder userInfoHolder, ConsumerTokenRepository consumerTokenRepository, ConsumerRepository consumerRepository, ConsumerAuditRepository consumerAuditRepository, ConsumerRoleRepository consumerRoleRepository, PortalConfig portalConfig, RolePermissionService rolePermissionService, UserService userService) {
        this.userInfoHolder = userInfoHolder;
        this.consumerTokenRepository = consumerTokenRepository;
        this.consumerRepository = consumerRepository;
        this.consumerAuditRepository = consumerAuditRepository;
        this.consumerRoleRepository = consumerRoleRepository;
        this.portalConfig = portalConfig;
        this.rolePermissionService = rolePermissionService;
        this.userService = userService;
    }

    public Consumer createConsumer(Consumer consumer) {
        String appId = consumer.getAppId();
        Consumer managedConsumer = this.consumerRepository.findByAppId(appId);
        if (managedConsumer != null) {
            throw new BadRequestException("Consumer already exist");
        }
        String ownerName = consumer.getOwnerName();
        UserInfo owner = this.userService.findByUserId(ownerName);
        if (owner == null) {
            throw new BadRequestException(String.format("User does not exist. UserId = %s", ownerName));
        }
        consumer.setOwnerEmail(owner.getEmail());
        String operator = this.userInfoHolder.getUser().getUserId();
        consumer.setDataChangeCreatedBy(operator);
        consumer.setDataChangeLastModifiedBy(operator);
        return (Consumer)((Object)this.consumerRepository.save((Object)consumer));
    }

    public ConsumerToken generateAndSaveConsumerToken(Consumer consumer, Date expires) {
        Preconditions.checkArgument((consumer != null ? 1 : 0) != 0, (Object)"Consumer can not be null");
        ConsumerToken consumerToken = this.generateConsumerToken(consumer, expires);
        consumerToken.setId(0L);
        return (ConsumerToken)((Object)this.consumerTokenRepository.save((Object)consumerToken));
    }

    public ConsumerToken getConsumerTokenByAppId(String appId) {
        Consumer consumer = this.consumerRepository.findByAppId(appId);
        if (consumer == null) {
            return null;
        }
        return this.consumerTokenRepository.findByConsumerId(consumer.getId());
    }

    public Long getConsumerIdByToken(String token) {
        if (Strings.isNullOrEmpty((String)token)) {
            return null;
        }
        ConsumerToken consumerToken = this.consumerTokenRepository.findTopByTokenAndExpiresAfter(token, new Date());
        return consumerToken == null ? null : Long.valueOf(consumerToken.getConsumerId());
    }

    public Consumer getConsumerByConsumerId(long consumerId) {
        return this.consumerRepository.findById(consumerId).orElse(null);
    }

    public List<ConsumerRole> assignNamespaceRoleToConsumer(String token, String appId, String namespaceName) {
        return this.assignNamespaceRoleToConsumer(token, appId, namespaceName, null);
    }

    @Transactional
    public List<ConsumerRole> assignNamespaceRoleToConsumer(String token, String appId, String namespaceName, String env) {
        Long consumerId = this.getConsumerIdByToken(token);
        if (consumerId == null) {
            throw new BadRequestException("Token is Illegal");
        }
        Role namespaceModifyRole = this.rolePermissionService.findRoleByRoleName(RoleUtils.buildModifyNamespaceRoleName(appId, namespaceName, env));
        Role namespaceReleaseRole = this.rolePermissionService.findRoleByRoleName(RoleUtils.buildReleaseNamespaceRoleName(appId, namespaceName, env));
        if (namespaceModifyRole == null || namespaceReleaseRole == null) {
            throw new BadRequestException("Namespace's role does not exist. Please check whether namespace has created.");
        }
        long namespaceModifyRoleId = namespaceModifyRole.getId();
        long namespaceReleaseRoleId = namespaceReleaseRole.getId();
        ConsumerRole managedModifyRole = this.consumerRoleRepository.findByConsumerIdAndRoleId(consumerId, namespaceModifyRoleId);
        ConsumerRole managedReleaseRole = this.consumerRoleRepository.findByConsumerIdAndRoleId(consumerId, namespaceReleaseRoleId);
        if (managedModifyRole != null && managedReleaseRole != null) {
            return Arrays.asList(managedModifyRole, managedReleaseRole);
        }
        String operator = this.userInfoHolder.getUser().getUserId();
        ConsumerRole namespaceModifyConsumerRole = this.createConsumerRole(consumerId, namespaceModifyRoleId, operator);
        ConsumerRole namespaceReleaseConsumerRole = this.createConsumerRole(consumerId, namespaceReleaseRoleId, operator);
        ConsumerRole createdModifyConsumerRole = (ConsumerRole)((Object)this.consumerRoleRepository.save((Object)namespaceModifyConsumerRole));
        ConsumerRole createdReleaseConsumerRole = (ConsumerRole)((Object)this.consumerRoleRepository.save((Object)namespaceReleaseConsumerRole));
        return Arrays.asList(createdModifyConsumerRole, createdReleaseConsumerRole);
    }

    @Transactional
    public ConsumerRole assignAppRoleToConsumer(String token, String appId) {
        Long consumerId = this.getConsumerIdByToken(token);
        if (consumerId == null) {
            throw new BadRequestException("Token is Illegal");
        }
        Role masterRole = this.rolePermissionService.findRoleByRoleName(RoleUtils.buildAppMasterRoleName(appId));
        if (masterRole == null) {
            throw new BadRequestException("App's role does not exist. Please check whether app has created.");
        }
        long roleId = masterRole.getId();
        ConsumerRole managedModifyRole = this.consumerRoleRepository.findByConsumerIdAndRoleId(consumerId, roleId);
        if (managedModifyRole != null) {
            return managedModifyRole;
        }
        String operator = this.userInfoHolder.getUser().getUserId();
        ConsumerRole consumerRole = this.createConsumerRole(consumerId, roleId, operator);
        return (ConsumerRole)((Object)this.consumerRoleRepository.save((Object)consumerRole));
    }

    @Transactional
    public void createConsumerAudits(Iterable<ConsumerAudit> consumerAudits) {
        this.consumerAuditRepository.saveAll(consumerAudits);
    }

    @Transactional
    public ConsumerToken createConsumerToken(ConsumerToken entity) {
        entity.setId(0L);
        return (ConsumerToken)((Object)this.consumerTokenRepository.save((Object)entity));
    }

    private ConsumerToken generateConsumerToken(Consumer consumer, Date expires) {
        long consumerId = consumer.getId();
        String createdBy = this.userInfoHolder.getUser().getUserId();
        Date createdTime = new Date();
        ConsumerToken consumerToken = new ConsumerToken();
        consumerToken.setConsumerId(consumerId);
        consumerToken.setExpires(expires);
        consumerToken.setDataChangeCreatedBy(createdBy);
        consumerToken.setDataChangeCreatedTime(createdTime);
        consumerToken.setDataChangeLastModifiedBy(createdBy);
        consumerToken.setDataChangeLastModifiedTime(createdTime);
        this.generateAndEnrichToken(consumer, consumerToken);
        return consumerToken;
    }

    void generateAndEnrichToken(Consumer consumer, ConsumerToken consumerToken) {
        Preconditions.checkArgument((consumer != null ? 1 : 0) != 0);
        if (consumerToken.getDataChangeCreatedTime() == null) {
            consumerToken.setDataChangeCreatedTime(new Date());
        }
        consumerToken.setToken(this.generateToken(consumer.getAppId(), consumerToken.getDataChangeCreatedTime(), this.portalConfig.consumerTokenSalt()));
    }

    String generateToken(String consumerAppId, Date generationTime, String consumerTokenSalt) {
        return Hashing.sha1().hashString((CharSequence)KEY_JOINER.join((Object)consumerAppId, (Object)TIMESTAMP_FORMAT.format(generationTime), new Object[]{consumerTokenSalt}), Charsets.UTF_8).toString();
    }

    ConsumerRole createConsumerRole(Long consumerId, Long roleId, String operator) {
        ConsumerRole consumerRole = new ConsumerRole();
        consumerRole.setConsumerId(consumerId);
        consumerRole.setRoleId(roleId);
        consumerRole.setDataChangeCreatedBy(operator);
        consumerRole.setDataChangeLastModifiedBy(operator);
        return consumerRole;
    }
}

