/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.service;

import com.ctrip.framework.apollo.openapi.entity.ConsumerRole;
import com.ctrip.framework.apollo.openapi.repository.ConsumerRoleRepository;
import com.ctrip.framework.apollo.portal.entity.po.Permission;
import com.ctrip.framework.apollo.portal.entity.po.RolePermission;
import com.ctrip.framework.apollo.portal.repository.PermissionRepository;
import com.ctrip.framework.apollo.portal.repository.RolePermissionRepository;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConsumerRolePermissionService {
    private final PermissionRepository permissionRepository;
    private final ConsumerRoleRepository consumerRoleRepository;
    private final RolePermissionRepository rolePermissionRepository;

    public ConsumerRolePermissionService(PermissionRepository permissionRepository, ConsumerRoleRepository consumerRoleRepository, RolePermissionRepository rolePermissionRepository) {
        this.permissionRepository = permissionRepository;
        this.consumerRoleRepository = consumerRoleRepository;
        this.rolePermissionRepository = rolePermissionRepository;
    }

    public boolean consumerHasPermission(long consumerId, String permissionType, String targetId) {
        Permission permission = this.permissionRepository.findTopByPermissionTypeAndTargetId(permissionType, targetId);
        if (permission == null) {
            return false;
        }
        List<ConsumerRole> consumerRoles = this.consumerRoleRepository.findByConsumerId(consumerId);
        if (CollectionUtils.isEmpty(consumerRoles)) {
            return false;
        }
        Set<Long> roleIds = consumerRoles.stream().map(ConsumerRole::getRoleId).collect(Collectors.toSet());
        List<RolePermission> rolePermissions = this.rolePermissionRepository.findByRoleIdIn(roleIds);
        if (CollectionUtils.isEmpty(rolePermissions)) {
            return false;
        }
        for (RolePermission rolePermission : rolePermissions) {
            if (rolePermission.getPermissionId() != permission.getId()) continue;
            return true;
        }
        return false;
    }
}

