/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.auth;

import com.ctrip.framework.apollo.openapi.service.ConsumerRolePermissionService;
import com.ctrip.framework.apollo.openapi.util.ConsumerAuthUtil;
import com.ctrip.framework.apollo.portal.util.RoleUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class ConsumerPermissionValidator {
    private final ConsumerRolePermissionService permissionService;
    private final ConsumerAuthUtil consumerAuthUtil;

    public ConsumerPermissionValidator(ConsumerRolePermissionService permissionService, ConsumerAuthUtil consumerAuthUtil) {
        this.permissionService = permissionService;
        this.consumerAuthUtil = consumerAuthUtil;
    }

    public boolean hasModifyNamespacePermission(HttpServletRequest request, String appId, String namespaceName, String env) {
        if (this.hasCreateNamespacePermission(request, appId)) {
            return true;
        }
        return this.permissionService.consumerHasPermission(this.consumerAuthUtil.retrieveConsumerId(request), "ModifyNamespace", RoleUtils.buildNamespaceTargetId(appId, namespaceName)) || this.permissionService.consumerHasPermission(this.consumerAuthUtil.retrieveConsumerId(request), "ModifyNamespace", RoleUtils.buildNamespaceTargetId(appId, namespaceName, env));
    }

    public boolean hasReleaseNamespacePermission(HttpServletRequest request, String appId, String namespaceName, String env) {
        if (this.hasCreateNamespacePermission(request, appId)) {
            return true;
        }
        return this.permissionService.consumerHasPermission(this.consumerAuthUtil.retrieveConsumerId(request), "ReleaseNamespace", RoleUtils.buildNamespaceTargetId(appId, namespaceName)) || this.permissionService.consumerHasPermission(this.consumerAuthUtil.retrieveConsumerId(request), "ReleaseNamespace", RoleUtils.buildNamespaceTargetId(appId, namespaceName, env));
    }

    public boolean hasCreateNamespacePermission(HttpServletRequest request, String appId) {
        return this.permissionService.consumerHasPermission(this.consumerAuthUtil.retrieveConsumerId(request), "CreateNamespace", appId);
    }

    public boolean hasCreateClusterPermission(HttpServletRequest request, String appId) {
        return this.permissionService.consumerHasPermission(this.consumerAuthUtil.retrieveConsumerId(request), "CreateCluster", appId);
    }
}

